/*
 * Decompiled with CFR 0.152.
 */
package com.zuehlke.qtag.cli;

import com.zuehlke.qtag.cli.ExitCode;
import com.zuehlke.qtag.parser.log.MissingKeyException;
import com.zuehlke.qtag.parser.log.UnsupportedLogFileException;
import com.zuehlke.qtag.parser.obfuscation.LogFileDecrypter;
import com.zuehlke.qtag.parser.verification.FileSignatureVerifier;
import java.io.File;
import java.io.IOException;

public class Main {
    public static final String COMMAND_LINE_PARAM_DO_NOT_DECRYPT = "-doNotDecrypt";

    public static void main(String ... args) {
        try {
            String inputFilename = Main.getInputFilename(args);
            File inputFile = new File(inputFilename);
            FileSignatureVerifier verifier = FileSignatureVerifier.create();
            if (inputFilename.endsWith(".pdf")) {
                Main.handlePdfReportFile(verifier, inputFile);
            } else if (inputFilename.endsWith(".txt")) {
                Main.handleTxtLogFile(verifier, inputFile, args);
            } else {
                System.err.println("Error: Unknown file name extension, must be either '.pdf' or '.txt'.");
                System.exit(ExitCode.UNKNOWN_FILENAME_EXTENSION.getStatusCode());
            }
        }
        catch (IOException e) {
            System.err.println("Exception during processing file: " + e.getMessage());
            System.exit(ExitCode.ERROR_DURING_PROCESSING.getStatusCode());
        }
        catch (UnsupportedLogFileException e) {
            System.err.println("Unsupported log file: " + e.getMessage());
            System.exit(ExitCode.UNSUPPORTED_LOG_FILE.getStatusCode());
        }
        catch (MissingKeyException e) {
            System.err.println("Missing keys in logfile: " + e.getMessage());
            System.exit(ExitCode.MISSING_KEYS_IN_LOG_FILE.getStatusCode());
        }
    }

    private static String getInputFilename(String ... args) {
        String inputFilename;
        if (args.length < 1 || args[0].length() == 0) {
            System.err.println("Error: Filename of the file to be verified must be provided.");
            System.exit(ExitCode.INVALID_PROGRAM_ARGUMENTS.getStatusCode());
        }
        if (!new File(inputFilename = args[0]).canRead() || !new File(inputFilename).isFile()) {
            System.err.println("Error: Cannot read from file: " + inputFilename);
            System.exit(ExitCode.NO_READ_ACCESS.getStatusCode());
        }
        return inputFilename;
    }

    private static String getOutputFilename(String ... args) {
        String outputFilename;
        if (args.length == 2) {
            outputFilename = args[1];
        } else {
            StringBuilder inputFilename = new StringBuilder(args[0]);
            outputFilename = inputFilename.insert(inputFilename.lastIndexOf("."), "_clear").toString();
        }
        return outputFilename;
    }

    private static boolean doNotDecrypt(String ... args) {
        for (String arg : args) {
            if (!COMMAND_LINE_PARAM_DO_NOT_DECRYPT.equalsIgnoreCase(arg)) continue;
            return true;
        }
        return false;
    }

    private static void handleTxtLogFile(FileSignatureVerifier verifier, File inputFile, String ... args) throws IOException, MissingKeyException, UnsupportedLogFileException {
        if (LogFileDecrypter.isEncrypted(inputFile)) {
            Main.handleEncryptedLogFile(inputFile, args);
            Main.exitWithCorrectExitCode(null);
        } else {
            Main.exitWithCorrectExitCode(verifier.isLogSignatureValid(inputFile));
        }
    }

    private static void handleEncryptedLogFile(File inputFile, String ... args) throws IOException {
        if (!Main.doNotDecrypt(args)) {
            String outputFilename = Main.getOutputFilename(args);
            File outputFile = new File(outputFilename);
            Main.requireOutputFile(outputFile);
            LogFileDecrypter.decrypt(inputFile, outputFile);
        }
    }

    private static void requireOutputFile(File outputFile) {
        try {
            outputFile.createNewFile();
        }
        catch (IOException e) {
            System.err.println("Error: Cannot create output file: " + outputFile);
            System.exit(ExitCode.NO_WRITE_ACCESS.getStatusCode());
        }
        if (!outputFile.canWrite()) {
            System.err.println("Error: Cannot write to file: " + outputFile);
            System.exit(ExitCode.NO_WRITE_ACCESS.getStatusCode());
        }
    }

    private static void handlePdfReportFile(FileSignatureVerifier verifier, File inputFile) throws IOException {
        Main.exitWithCorrectExitCode(verifier.isPdfSignatureValid(inputFile));
    }

    private static void exitWithCorrectExitCode(Boolean signatureValid) {
        if (signatureValid == null) {
            System.exit(ExitCode.SIGNATURE_NOT_VERIFIED.getStatusCode());
        } else if (signatureValid.booleanValue()) {
            System.exit(ExitCode.SIGNATURE_VALID.getStatusCode());
        } else {
            System.exit(ExitCode.SIGNATURE_INVALID.getStatusCode());
        }
    }
}

