/*
 * Decompiled with CFR 0.152.
 */
package com.zuehlke.qtag.gui.ui;

import com.zuehlke.qtag.logfile.LogFileReaderVerifier;
import com.zuehlke.qtag.parser.log.model.ISensorAlarm;
import com.zuehlke.qtag.parser.log.model.ITemperatureAlarm;
import com.zuehlke.qtag.parser.log.model.LogData;
import com.zuehlke.qtag.parser.log.model.clmdoc.ITransportDuration;
import com.zuehlke.qtag.parser.log.model.clmdoc.TransportDurationStatus;
import com.zuehlke.qtag.parser.verification.FileSignatureVerifier;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Objects;

class BulkDirectoryProcessor {
    private int directoryCount = 0;
    private int ignoredFileCount = 0;
    private int overallFileCount = 0;
    private int failedFileCount = 0;
    private OutputStream directoryProcessingDetailsStream;
    private File directory;

    public BulkDirectoryProcessor(File directory) {
        this.directory = directory;
        this.directoryProcessingDetailsStream = new ByteArrayOutputStream();
        PrintStream detailLog = new PrintStream(this.directoryProcessingDetailsStream);
        detailLog.print("<html>");
        this.handleDirectory(directory, detailLog);
        detailLog.print("</html>");
        try {
            this.directoryProcessingDetailsStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void handleDirectory(File directory, PrintStream detailLog) {
        ++this.directoryCount;
        for (File file : Objects.requireNonNull(directory.listFiles())) {
            if (file.isDirectory()) {
                this.handleDirectory(file, detailLog);
                continue;
            }
            this.handleSingleFile(detailLog, file);
        }
    }

    private void handleSingleFile(PrintStream detailLog, File file) {
        try {
            ++this.overallFileCount;
            if (file.getName().toLowerCase().endsWith(".txt")) {
                boolean signatureValid = FileSignatureVerifier.create().isLogSignatureValid(file);
                boolean bAlarmOccurred = false;
                boolean bTransportDurationExpired = false;
                if (signatureValid) {
                    TransportDurationStatus status;
                    LogData logData = LogFileReaderVerifier.readLogFileData(file);
                    if (logData instanceof ITemperatureAlarm) {
                        bAlarmOccurred |= ((ITemperatureAlarm)((Object)logData)).isTemperatureAlarmOccurred();
                    }
                    if (logData instanceof ISensorAlarm) {
                        bAlarmOccurred |= ((ISensorAlarm)((Object)logData)).isSensorAlarmOccurred();
                    }
                    if (logData instanceof ITransportDuration && TransportDurationStatus.EXPIRED.equals((Object)(status = ((ITransportDuration)((Object)logData)).getTransportDurationStatus()))) {
                        bTransportDurationExpired = true;
                    }
                }
                this.checkFile(detailLog, file, signatureValid, bAlarmOccurred, bTransportDurationExpired);
            } else if (file.getName().toLowerCase().endsWith(".pdf")) {
                boolean signatureValid = FileSignatureVerifier.create().isPdfSignatureValid(file);
                this.checkFile(detailLog, file, signatureValid, false, false);
            } else {
                ++this.ignoredFileCount;
                detailLog.println("<font color=\"blue\">" + file.getPath() + ": Ignored</font><br />");
            }
        }
        catch (Exception e) {
            ++this.failedFileCount;
            detailLog.println("<font color=\"red\">" + file.getPath() + ": Error (" + e.getMessage() + ")</font><br />");
        }
    }

    private void checkFile(PrintStream detailLog, File file, boolean signatureValid, boolean hasAlarms, boolean transportDurationExpired) {
        if (signatureValid && !hasAlarms && !transportDurationExpired) {
            detailLog.println("<font color=\"green\">" + file.getPath() + ": Ok</font><br />");
            return;
        }
        ++this.failedFileCount;
        String binder = "";
        StringBuilder builder = new StringBuilder("<font color=\"red\">" + file.getPath() + ": ");
        if (!signatureValid) {
            builder.append("Signature invalid");
            binder = ", ";
        }
        if (hasAlarms) {
            builder.append(binder).append("Alarms triggered");
            binder = ", ";
        }
        if (transportDurationExpired) {
            builder.append(binder).append("Transport duration expired");
        }
        builder.append("</font><br />");
        detailLog.println(builder);
    }

    public String getProcessingDetails() {
        return this.directoryProcessingDetailsStream.toString();
    }

    public int getDirectoryCount() {
        return this.directoryCount;
    }

    public int getOverallFileCount() {
        return this.overallFileCount;
    }

    public int getIgnoredFileCount() {
        return this.ignoredFileCount;
    }

    public int getFailedFileCount() {
        return this.failedFileCount;
    }

    public File getDirectory() {
        return this.directory;
    }
}

