/*
 * Decompiled with CFR 0.152.
 */
package com.zuehlke.qtag.gui.ui;

import com.zuehlke.qtag.gui.ui.BulkDirectoryProcessor;
import com.zuehlke.qtag.gui.ui.LogFileCardPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

class DirectoryCardPanel
extends JPanel {
    private static final long serialVersionUID = -1668488121991577183L;
    private static final ImageIcon FAIL_ICON = new ImageIcon(LogFileCardPanel.class.getResource("/fail.png"), "failed");
    private static final ImageIcon OK_ICON = new ImageIcon(LogFileCardPanel.class.getResource("/ok.png"), "failed");
    private static final ResourceBundle rb = ResourceBundle.getBundle("i18n", Locale.getDefault());
    private JLabel overallSuccessIconLabel;
    private JLabel directoryCountLabel;
    private JLabel checkedFilesCountLabel;
    private JLabel failedFilesCountLabel;
    private JLabel ignoredFileCountLabel;
    private JButton showDirectoryDetailsButton;

    public DirectoryCardPanel() {
        this.setLayout(new GridBagLayout());
        this.add((Component)new JLabel("All files OK?"), DirectoryCardPanel.createGridBagConstraint(0, 0));
        this.overallSuccessIconLabel = new JLabel("");
        this.add((Component)this.overallSuccessIconLabel, DirectoryCardPanel.createGridBagConstraint(1, 0));
        this.add((Component)new JLabel("Directories scanned: "), DirectoryCardPanel.createGridBagConstraint(0, 1));
        this.directoryCountLabel = new JLabel();
        this.add((Component)this.directoryCountLabel, DirectoryCardPanel.createGridBagConstraint(1, 1));
        this.add((Component)new JLabel("Files checked: "), DirectoryCardPanel.createGridBagConstraint(0, 2));
        this.checkedFilesCountLabel = new JLabel("");
        this.add((Component)this.checkedFilesCountLabel, DirectoryCardPanel.createGridBagConstraint(1, 2));
        this.add((Component)new JLabel("Files ignored: "), DirectoryCardPanel.createGridBagConstraint(3, 1));
        this.ignoredFileCountLabel = new JLabel("");
        this.add((Component)this.ignoredFileCountLabel, DirectoryCardPanel.createGridBagConstraint(4, 1));
        this.add((Component)new JLabel("Files with problems: "), DirectoryCardPanel.createGridBagConstraint(3, 2));
        this.failedFilesCountLabel = new JLabel("");
        this.add((Component)this.failedFilesCountLabel, DirectoryCardPanel.createGridBagConstraint(4, 2));
        this.showDirectoryDetailsButton = DirectoryCardPanel.createShowDirectoryDetailsButton();
        GridBagConstraints gridBackConstraint = DirectoryCardPanel.createGridBagConstraint(0, 3, 0.5, 17, 0);
        gridBackConstraint.insets = new Insets(4, 0, 6, 8);
        this.add((Component)this.showDirectoryDetailsButton, gridBackConstraint);
    }

    private static JButton createShowDirectoryDetailsButton() {
        JButton button = new JButton(rb.getString("main.gui.directory.button.details"));
        button.setVerticalTextPosition(0);
        button.setHorizontalTextPosition(10);
        button.setMnemonic(68);
        button.setActionCommand("showDirectoryDetails");
        button.setMinimumSize(new Dimension(110, 24));
        button.setPreferredSize(new Dimension(110, 24));
        return button;
    }

    public void update(BulkDirectoryProcessor bulkDirectoryProcessor) {
        int notOkCount = bulkDirectoryProcessor.getIgnoredFileCount() + bulkDirectoryProcessor.getFailedFileCount();
        if (notOkCount == 0) {
            this.overallSuccessIconLabel.setIcon(OK_ICON);
        } else {
            this.overallSuccessIconLabel.setIcon(FAIL_ICON);
        }
        this.directoryCountLabel.setText(bulkDirectoryProcessor.getDirectoryCount() + "");
        this.checkedFilesCountLabel.setText(bulkDirectoryProcessor.getOverallFileCount() + "");
        this.ignoredFileCountLabel.setText(bulkDirectoryProcessor.getIgnoredFileCount() + "");
        this.failedFilesCountLabel.setText(bulkDirectoryProcessor.getFailedFileCount() + "");
    }

    public void addActionListener(ActionListener actionListener) {
        this.showDirectoryDetailsButton.addActionListener(actionListener);
    }

    private static GridBagConstraints createGridBagConstraint(int gridx, int gridy) {
        return DirectoryCardPanel.createGridBagConstraint(gridx, gridy, 0.5, 13, 2);
    }

    private static GridBagConstraints createGridBagConstraint(int gridx, int gridy, double weightx, int anchor, int fill) {
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(4, 8, 6, 8);
        c.fill = fill;
        c.gridx = gridx;
        c.gridy = gridy;
        c.weightx = weightx;
        c.weighty = 0.1;
        c.anchor = anchor;
        return c;
    }
}

