/*
 * Decompiled with CFR 0.152.
 */
package com.zuehlke.qtag.gui.ui;

import com.zuehlke.qtag.gui.ui.MyLoadDialog;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;

class GeneralLoadDialog
extends MyLoadDialog {
    private JFileChooser fileChooser;
    private JFrame parentFrame;

    GeneralLoadDialog(JFrame parentFrame, String title, final boolean enableDirectorySelection, final String ... allowedFilenameExtensions) {
        this.parentFrame = parentFrame;
        this.fileChooser = new JFileChooser();
        if (enableDirectorySelection) {
            this.fileChooser.setFileSelectionMode(2);
        } else {
            this.fileChooser.setFileSelectionMode(0);
        }
        this.fileChooser.setDialogTitle(title);
        this.fileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (allowedFilenameExtensions.length == 0 && !enableDirectorySelection) {
                    return true;
                }
                if (f.isDirectory()) {
                    return true;
                }
                for (String extension : allowedFilenameExtensions) {
                    if (!f.getName().toLowerCase().endsWith(extension)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String getDescription() {
                if (allowedFilenameExtensions.length == 0) {
                    if (enableDirectorySelection) {
                        return "directories only";
                    }
                    return "*.*";
                }
                StringBuilder builder = new StringBuilder("*" + allowedFilenameExtensions[0]);
                for (String allowedFilenameExtension : allowedFilenameExtensions) {
                    if (allowedFilenameExtension.equals(allowedFilenameExtensions[0])) continue;
                    builder.append(", *").append(allowedFilenameExtension);
                }
                return builder.toString();
            }
        });
    }

    @Override
    public File show() {
        int status = this.fileChooser.showOpenDialog(this.parentFrame);
        if (status == 0) {
            return this.fileChooser.getSelectedFile();
        }
        return null;
    }

    @Override
    public void setCurrentDirectory(File dir) {
        this.fileChooser.setCurrentDirectory(dir);
    }

    @Override
    public File show(File preset) {
        if (preset != null) {
            this.fileChooser.setCurrentDirectory(preset.getParentFile());
            this.fileChooser.setSelectedFile(preset);
        }
        return this.show();
    }
}

