/*
 * Decompiled with CFR 0.152.
 */
package com.zuehlke.qtag.gui.ui;

import com.zuehlke.qtag.gui.util.ApplicationProperties;
import com.zuehlke.qtag.parser.log.model.IErrors;
import com.zuehlke.qtag.parser.log.model.ISensorAlarm;
import com.zuehlke.qtag.parser.log.model.ITemperatureAlarm;
import com.zuehlke.qtag.parser.log.model.LogData;
import com.zuehlke.qtag.parser.log.model.clmdoc.ITransportDuration;
import com.zuehlke.qtag.parser.log.model.clmdoc.LogDataCLmdoc;
import com.zuehlke.qtag.parser.log.model.clmdoc.TransportDurationStatus;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

class LogFileCardPanel
extends JPanel {
    private static final long serialVersionUID = 6093120823386868316L;
    private static final ImageIcon FAIL_ICON = new ImageIcon(LogFileCardPanel.class.getResource("/fail.png"), "failed");
    private static final ImageIcon OK_ICON = new ImageIcon(LogFileCardPanel.class.getResource("/ok.png"), "failed");
    private static final ResourceBundle rb = ResourceBundle.getBundle("i18n", Locale.getDefault());
    private JLabel tagStatusLabel;
    private JLabel tagStatusImgLabel;
    private JLabel transportStatusLabel;
    private JLabel transportStatusImgLabel;
    private JLabel sigStatusImgLabel;
    private JButton vacReportCreationButton;
    private JButton addToVacReportButton;

    public LogFileCardPanel() {
        String customerType = ApplicationProperties.getAppProperty("application.gui.customer.type", "basic");
        this.setLayout(new GridBagLayout());
        this.tagStatusLabel = new JLabel(rb.getString("main.gui.status.alarm"));
        GridBagConstraints gridBagConstraint = LogFileCardPanel.createGridBagConstraint(0, 2, 0.1);
        gridBagConstraint.insets = new Insets(4, 8, 6, 8);
        this.add((Component)this.tagStatusLabel, gridBagConstraint);
        this.tagStatusImgLabel = new JLabel();
        this.tagStatusImgLabel.setHorizontalAlignment(10);
        this.add((Component)this.tagStatusImgLabel, LogFileCardPanel.createGridBagConstraint(1, 2, 0.9));
        this.transportStatusLabel = new JLabel(rb.getString("main.gui.status.trspduration"));
        gridBagConstraint = LogFileCardPanel.createGridBagConstraint(0, 3, 0.1);
        gridBagConstraint.insets = new Insets(4, 8, 6, 8);
        this.add((Component)this.transportStatusLabel, gridBagConstraint);
        this.transportStatusImgLabel = new JLabel();
        this.transportStatusImgLabel.setHorizontalAlignment(10);
        this.add((Component)this.transportStatusImgLabel, LogFileCardPanel.createGridBagConstraint(1, 3, 0.9));
        JLabel sigStatusLabel = new JLabel(rb.getString("main.gui.status.signature"));
        gridBagConstraint = LogFileCardPanel.createGridBagConstraint(0, 1, 0.1);
        gridBagConstraint.insets = new Insets(4, 8, 6, 8);
        this.add((Component)sigStatusLabel, gridBagConstraint);
        this.sigStatusImgLabel = new JLabel();
        this.sigStatusImgLabel.setHorizontalAlignment(10);
        this.add((Component)this.sigStatusImgLabel, LogFileCardPanel.createGridBagConstraint(1, 1, 0.9));
        this.vacReportCreationButton = LogFileCardPanel.createVacReportCreationButton();
        this.addToVacReportButton = LogFileCardPanel.createAddToVacReportButton();
        if (customerType.equals("unicef") || customerType.equals("full")) {
            this.add((Component)this.vacReportCreationButton, LogFileCardPanel.createGridBagConstraint(1, 4, 0.9, 13, 0));
            this.add((Component)this.addToVacReportButton, LogFileCardPanel.createGridBagConstraint(2, 4, 0.1, 13, 0));
        }
    }

    private static JButton createVacReportCreationButton() {
        JButton button = new JButton(rb.getString("main.gui.button.createVacReport"));
        button.setMnemonic(86);
        button.setActionCommand("createVacReport");
        return button;
    }

    private static JButton createAddToVacReportButton() {
        JButton button = new JButton(rb.getString("main.gui.button.addToVacReport"));
        button.setMnemonic(65);
        button.setActionCommand("addToVacReport");
        return button;
    }

    public void update(boolean signatureValid) {
        this.sigStatusImgLabel.setIcon(signatureValid ? OK_ICON : FAIL_ICON);
        this.tagStatusLabel.setVisible(false);
        this.tagStatusImgLabel.setVisible(false);
        this.transportStatusImgLabel.setVisible(false);
        this.transportStatusLabel.setVisible(false);
        this.vacReportCreationButton.setVisible(false);
        this.addToVacReportButton.setVisible(false);
    }

    public void update(LogData logFileData, boolean signatureValid) {
        if (logFileData == null) {
            this.update(signatureValid);
        } else {
            boolean alarmOccurred = false;
            TransportDurationStatus transportDurationStatus = TransportDurationStatus.NOT_MONITORED;
            boolean errorsOccurred = false;
            boolean enableVaccineReport = false;
            if (logFileData instanceof ITemperatureAlarm) {
                alarmOccurred |= ((ITemperatureAlarm)((Object)logFileData)).isTemperatureAlarmOccurred();
            }
            if (logFileData instanceof ISensorAlarm) {
                alarmOccurred |= ((ISensorAlarm)((Object)logFileData)).isSensorAlarmOccurred();
            }
            if (logFileData instanceof ITransportDuration) {
                transportDurationStatus = ((ITransportDuration)((Object)logFileData)).getTransportDurationStatus();
            }
            if (logFileData instanceof IErrors && !((IErrors)((Object)logFileData)).getErrors().isEmpty()) {
                errorsOccurred = true;
            }
            if (logFileData instanceof LogDataCLmdoc) {
                enableVaccineReport = true;
            }
            this.sigStatusImgLabel.setIcon(signatureValid ? OK_ICON : FAIL_ICON);
            this.tagStatusLabel.setVisible(true);
            this.tagStatusImgLabel.setVisible(true);
            this.tagStatusImgLabel.setIcon(alarmOccurred ? FAIL_ICON : OK_ICON);
            boolean transportStatusMonitored = !TransportDurationStatus.NOT_MONITORED.equals((Object)transportDurationStatus);
            this.transportStatusLabel.setVisible(transportStatusMonitored);
            this.transportStatusImgLabel.setVisible(transportStatusMonitored);
            this.transportStatusImgLabel.setIcon(TransportDurationStatus.EXPIRED.equals((Object)transportDurationStatus) ? FAIL_ICON : OK_ICON);
            if (enableVaccineReport && signatureValid && !errorsOccurred) {
                this.vacReportCreationButton.setVisible(true);
                this.addToVacReportButton.setVisible(true);
            }
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.vacReportCreationButton.addActionListener(actionListener);
        this.addToVacReportButton.addActionListener(actionListener);
    }

    private static GridBagConstraints createGridBagConstraint(int gridx, int gridy, double weightx) {
        return LogFileCardPanel.createGridBagConstraint(gridx, gridy, weightx, 10, 2);
    }

    private static GridBagConstraints createGridBagConstraint(int gridx, int gridy, double weightx, int anchor, int fill) {
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(4, 0, 6, 0);
        c.fill = fill;
        c.gridx = gridx;
        c.gridy = gridy;
        c.weightx = weightx;
        c.weighty = 0.1;
        c.anchor = anchor;
        return c;
    }
}

