/*
 * Decompiled with CFR 0.152.
 */
package com.zuehlke.qtag.gui.ui;

import com.zuehlke.qtag.gui.ui.MyLoadDialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FilenameFilter;
import javax.swing.JFrame;

class MacLoadDialog
extends MyLoadDialog {
    private FileDialog openFileDialog;
    private boolean enableDirectorySelection;

    MacLoadDialog(JFrame parentFrame, String title, boolean enableDirectorySelection, final String ... allowedFilenameExtensions) {
        this.enableDirectorySelection = enableDirectorySelection;
        this.openFileDialog = new FileDialog((Frame)parentFrame, title, 0);
        this.openFileDialog.setFilenameFilter(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (name == null) {
                    return false;
                }
                for (String extension : allowedFilenameExtensions) {
                    if (!name.toLowerCase().endsWith(extension)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    @Override
    public File show() {
        if (this.enableDirectorySelection) {
            System.setProperty("apple.awt.fileDialogForDirectories", "true");
        } else {
            System.setProperty("apple.awt.fileDialogForDirectories", "false");
        }
        this.openFileDialog.setVisible(true);
        System.setProperty("apple.awt.fileDialogForDirectories", "false");
        String selectedFile = this.openFileDialog.getFile();
        String selectedDir = this.openFileDialog.getDirectory();
        if (selectedFile != null && selectedDir != null) {
            return new File(selectedDir + selectedFile);
        }
        return null;
    }

    @Override
    public void setCurrentDirectory(File dir) {
        this.openFileDialog.setDirectory(dir.getPath());
    }

    @Override
    public File show(File preset) {
        if (preset != null) {
            this.openFileDialog.setDirectory(preset.getParent());
            this.openFileDialog.setFile(preset.getName());
        }
        return this.show();
    }
}

