/*
 * Decompiled with CFR 0.152.
 */
package com.zuehlke.qtag.gui.ui;

import com.zuehlke.qtag.gui.ui.BulkDirectoryProcessor;
import com.zuehlke.qtag.gui.ui.DirectoryDetailsViewerDialog;
import com.zuehlke.qtag.gui.ui.MainFrame;
import com.zuehlke.qtag.gui.ui.MyLoadDialog;
import com.zuehlke.qtag.gui.ui.UIHelper;
import com.zuehlke.qtag.gui.vaccinereport.VaccineReport;
import com.zuehlke.qtag.gui.vaccinereport.VaccineReportDialog;
import com.zuehlke.qtag.logfile.LogFileReaderVerifier;
import com.zuehlke.qtag.parser.log.model.LogData;
import com.zuehlke.qtag.parser.log.model.clmdoc.LogDataCLmdoc;
import com.zuehlke.qtag.parser.log.model.clmdoc.alarm.AlarmConfiguration;
import com.zuehlke.qtag.parser.log.model.fridgetag.LogDataFridgeTag;
import com.zuehlke.qtag.parser.verification.FileSignatureVerifier;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MainController
implements ActionListener,
Runnable {
    private static final Log log = LogFactory.getLog(MainController.class);
    private LogDataCLmdoc logCLmdocFileData;
    private MainFrame view;
    private MyLoadDialog openFileDialog;
    private MyLoadDialog openDirectoryDialog;
    private MyLoadDialog loadVacReportDialog;
    private File lastSavedVaccineReportFile;
    private BulkDirectoryProcessor bulkDirectoryProcessor;
    private File initialFile;

    @Override
    public void run() {
        this.view = new MainFrame();
        this.view.addActionListener(this);
        this.view.setVisible(true);
        this.view.setLocationRelativeTo(null);
        this.openFileDialog = MyLoadDialog.create(this.view, "file.open.title", false, ".txt", ".pdf");
        this.openDirectoryDialog = MyLoadDialog.create(this.view, "directory.open.title", true, new String[0]);
        this.loadVacReportDialog = MyLoadDialog.create(this.view, "vaccine.file.open.title", false, ".xlsx");
        this.handleSelectedFileOrDirectory(this.initialFile);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("openFile".equals(e.getActionCommand())) {
            this.onOpenFile();
        } else if ("openDirectory".equals(e.getActionCommand())) {
            this.onOpenDirectory();
        } else if ("createVacReport".equals(e.getActionCommand())) {
            this.onCreateVaccineReport();
        } else if ("addToVacReport".equals(e.getActionCommand())) {
            this.onAddToVaccineReport();
        } else if ("showDirectoryDetails".equals(e.getActionCommand())) {
            this.onShowDirectoryProcessingDetails();
        } else {
            throw new IllegalStateException("unknown action command: " + e.getActionCommand());
        }
    }

    private void onShowDirectoryProcessingDetails() {
        DirectoryDetailsViewerDialog directoryDetailsDialog = new DirectoryDetailsViewerDialog(this.bulkDirectoryProcessor.getProcessingDetails());
        directoryDetailsDialog.setVisible(true);
    }

    private void onAddToVaccineReport() {
        File file = this.loadVacReportDialog.show(this.lastSavedVaccineReportFile);
        if (file != null) {
            try {
                VaccineReport vaccineReport = new VaccineReport(file);
                if (!this.logCLmdocFileData.getConfiguration().getTimeZone().equals(vaccineReport.getPage4TimeZone())) {
                    UIHelper.showWarningMessage("error.vaccine.timezone", new Object[0]);
                    return;
                }
                if (!vaccineReport.doAlarmConfigsMatch(this.logCLmdocFileData)) {
                    UIHelper.showWarningMessage("vaccine.gui.alarmconfig.match.error", new Object[0]);
                    return;
                }
                VaccineReportDialog vaccineReportDialog = new VaccineReportDialog(vaccineReport, file, this.logCLmdocFileData);
                vaccineReportDialog.pack();
                vaccineReportDialog.setVisible(true);
                this.lastSavedVaccineReportFile = vaccineReportDialog.getVaccineReportFile();
            }
            catch (Exception e) {
                log.error("error during creating vaccine report from file " + file, e);
                UIHelper.showWarningMessage("vaccine.file.open.error", new Object[0]);
            }
        }
    }

    private void onCreateVaccineReport() {
        try {
            List<AlarmConfiguration> varFilteredAlarmConfigs = VaccineReport.getVARRelevantAlarmConfigs(this.logCLmdocFileData);
            if (varFilteredAlarmConfigs.size() > 4) {
                UIHelper.showWarningMessage("vaccine.gui.warning.toMuchAlarmConfigs", new Object[0]);
            }
            VaccineReport vaccineReport = VaccineReport.createNewFromTemplate(varFilteredAlarmConfigs, this.logCLmdocFileData.getConfiguration().getTimeZone());
            VaccineReportDialog vaccineReportDialog = new VaccineReportDialog(vaccineReport, null, this.logCLmdocFileData);
            vaccineReportDialog.pack();
            vaccineReportDialog.setVisible(true);
            this.lastSavedVaccineReportFile = vaccineReportDialog.getVaccineReportFile();
        }
        catch (IOException e) {
            log.error("error during creating vaccine report from template", e);
            UIHelper.showWarningMessage("error.general", new Object[0]);
        }
    }

    private void onOpenFile() {
        File file = this.openFileDialog.show();
        this.handleSelectedFileOrDirectory(file);
    }

    private void onOpenDirectory() {
        File file = this.openDirectoryDialog.show();
        this.handleSelectedFileOrDirectory(file);
    }

    private void handleSelectedFileOrDirectory(File file) {
        if (file == null) {
            return;
        }
        if (file.isDirectory()) {
            this.openDirectoryDialog.setCurrentDirectory(file.getParentFile());
            this.openFileDialog.setCurrentDirectory(file);
            this.handleDirectory(file);
        } else {
            File enclosingDirectory = file.getParentFile();
            this.openFileDialog.setCurrentDirectory(enclosingDirectory);
            if (enclosingDirectory.getParentFile() != null) {
                this.openDirectoryDialog.setCurrentDirectory(enclosingDirectory.getParentFile());
            } else {
                this.openDirectoryDialog.setCurrentDirectory(enclosingDirectory);
            }
            if (file.getName().toLowerCase().endsWith(".txt")) {
                this.handleLogFile(file);
            } else if (file.getName().toLowerCase().endsWith(".pdf")) {
                this.handlePdfFile(file);
            } else {
                log.warn("Can not identify the selected file type: " + file.getPath());
                UIHelper.showWarningMessage("error.file.type", new Object[0]);
            }
        }
    }

    private void handleDirectory(File directory) {
        try {
            this.bulkDirectoryProcessor = new BulkDirectoryProcessor(directory);
            this.view.updateContentPaneForDirectory(this.bulkDirectoryProcessor);
        }
        catch (Exception e) {
            this.view.updateContentPaneForError(directory.getPath());
            log.error("Exception during processing directory", e);
            UIHelper.showWarningMessage("error.processing.directory", e.getMessage());
        }
    }

    private void handlePdfFile(File file) {
        try {
            boolean signatureValid = FileSignatureVerifier.create().isPdfSignatureValid(file);
            if (!signatureValid) {
                UIHelper.showWarningMessage("warning.signature.invalid", new Object[0]);
            }
            this.view.updateContentPaneForSignatureCheckOnlyFile(file.getName(), signatureValid);
        }
        catch (Exception e) {
            this.view.updateContentPaneForError(file.getName());
            log.error("Exception during processing the pdf file", e);
            UIHelper.showWarningMessage("error.reading.file", e.getMessage());
        }
    }

    private void handleLogFile(File file) {
        boolean signatureValid;
        try {
            signatureValid = FileSignatureVerifier.create().isLogSignatureValid(file);
            this.view.updateContentPaneForLog(file.getName(), null, signatureValid);
            if (!signatureValid) {
                UIHelper.showWarningMessage("warning.signature.invalid", new Object[0]);
                return;
            }
        }
        catch (Exception e) {
            this.view.updateContentPaneForError(file.getName());
            log.error("error during checking signature", e);
            UIHelper.showWarningMessage("error.reading.file", e.getMessage());
            return;
        }
        try {
            LogData logData = LogFileReaderVerifier.readLogFileData(file);
            if (logData instanceof LogDataCLmdoc) {
                this.logCLmdocFileData = (LogDataCLmdoc)logData;
                this.view.updateContentPaneForLog(file.getName(), logData, signatureValid);
            } else if (logData instanceof LogDataFridgeTag) {
                this.view.updateContentPaneForLog(file.getName(), logData, signatureValid);
            } else {
                this.view.updateContentPaneForSignatureCheckOnlyFile(file.getName(), signatureValid);
            }
        }
        catch (Exception e) {
            log.error("error during processing log file", e);
            UIHelper.showWarningMessage("error.reading.file", e.getMessage());
        }
    }

    public void setInitialFile(File initialFile) {
        this.initialFile = initialFile;
    }
}

