/*
 * Decompiled with CFR 0.152.
 */
package com.zuehlke.qtag.gui.ui;

import com.zuehlke.qtag.gui.ui.BulkDirectoryProcessor;
import com.zuehlke.qtag.gui.ui.DirectoryCardPanel;
import com.zuehlke.qtag.gui.ui.LogFileCardPanel;
import com.zuehlke.qtag.gui.ui.PdfFileCardPanel;
import com.zuehlke.qtag.gui.util.ApplicationProperties;
import com.zuehlke.qtag.parser.log.model.LogData;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

class MainFrame
extends JFrame {
    private static final long serialVersionUID = 3199943462873040822L;
    private static final String DEFAULT_PROGRAM_ICON = "/application_icon.png";
    private static final String DEFAULT_MAIN_GUI_IMAGE = "/application_logo.jpg";
    private static final Dimension PREFERRED_SIZE = new Dimension(491, 800);
    private static final Color BACKGROUND_COLOR = Color.WHITE;
    private static final ResourceBundle rb = ResourceBundle.getBundle("i18n", Locale.getDefault());
    private static final String LOG_CARD_NAME = "log";
    private static final String PDF_CARD_NAME = "pdf";
    private static final String DIRECTORY_CARD_NAME = "directory";
    private static final String EMPTY_CARD_NAME = "empty";
    private JLabel fileInfoLabel;
    private JButton selectFileButton;
    private JButton selectDirectoryButton;
    private JPanel cards;
    private CardLayout cardLayout;
    private final DirectoryCardPanel directoryCardPanel = new DirectoryCardPanel();
    private final LogFileCardPanel logFileCardPanel = new LogFileCardPanel();
    private final PdfFileCardPanel pdfFileCardPanel = new PdfFileCardPanel();

    public MainFrame() {
        super(rb.getString("app.name") + " " + ApplicationProperties.getAppProperty("application.version", ""));
        this.setDefaultCloseOperation(3);
        this.setPreferredSize(PREFERRED_SIZE);
        this.setBackground(BACKGROUND_COLOR);
        this.setIconImage(new ImageIcon(this.getClass().getResource(DEFAULT_PROGRAM_ICON)).getImage());
        JPanel gui = new JPanel();
        gui.setBackground(BACKGROUND_COLOR);
        gui.setLayout(new BoxLayout(gui, 1));
        gui.add(this.createAppLogo());
        gui.add(this.createMainPanel());
        this.add(gui);
        this.pack();
    }

    private Component createAppLogo() {
        String imgPath = ApplicationProperties.getAppProperty("gui.main.image.file", DEFAULT_MAIN_GUI_IMAGE);
        ImageIcon image = new ImageIcon(this.getClass().getResource(imgPath));
        return new JLabel(image);
    }

    private JPanel createMainPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBackground(BACKGROUND_COLOR);
        panel.setAlignmentX(0.0f);
        panel.setBorder(BorderFactory.createTitledBorder(rb.getString("app.name")));
        this.selectFileButton = MainFrame.createFileSelectionButton();
        this.selectFileButton.setMinimumSize(new Dimension(90, 24));
        this.selectFileButton.setPreferredSize(new Dimension(90, 24));
        this.selectDirectoryButton = MainFrame.createDirectorySelectionButton();
        this.selectDirectoryButton.setMinimumSize(new Dimension(120, 24));
        this.selectDirectoryButton.setPreferredSize(new Dimension(120, 24));
        this.fileInfoLabel = new JLabel("");
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 13;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets = new Insets(5, 5, 10, 5);
        constraints.fill = 0;
        panel.add((Component)this.selectFileButton, constraints);
        constraints.gridx = 1;
        panel.add((Component)this.selectDirectoryButton, constraints);
        constraints.gridx = 2;
        constraints.weightx = 0.9;
        constraints.fill = 2;
        panel.add((Component)this.fileInfoLabel, constraints);
        this.cards = this.createCardsPanel();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.fill = 1;
        constraints.weighty = 0.9;
        constraints.gridwidth = 3;
        constraints.insets = new Insets(5, 5, 6, 5);
        panel.add((Component)this.cards, constraints);
        return panel;
    }

    private JPanel createCardsPanel() {
        this.cardLayout = new CardLayout();
        JPanel cards = new JPanel(this.cardLayout);
        JPanel startCardPanel = new JPanel(new FlowLayout(3));
        startCardPanel.add(new JLabel(rb.getString("main.gui.info.start")));
        cards.add((Component)startCardPanel, EMPTY_CARD_NAME);
        cards.add((Component)this.logFileCardPanel, LOG_CARD_NAME);
        cards.add((Component)this.pdfFileCardPanel, PDF_CARD_NAME);
        cards.add((Component)this.directoryCardPanel, DIRECTORY_CARD_NAME);
        for (Component component : cards.getComponents()) {
            component.setBackground(BACKGROUND_COLOR);
        }
        return cards;
    }

    private static JButton createFileSelectionButton() {
        JButton button = new JButton(rb.getString("main.gui.button.selectfile"));
        button.setVerticalTextPosition(0);
        button.setHorizontalTextPosition(10);
        button.setMnemonic(83);
        button.setActionCommand("openFile");
        return button;
    }

    private static JButton createDirectorySelectionButton() {
        JButton button = new JButton(rb.getString("main.gui.button.selectdirectory"));
        button.setVerticalTextPosition(0);
        button.setHorizontalTextPosition(10);
        button.setMnemonic(68);
        button.setActionCommand("openDirectory");
        return button;
    }

    public void updateContentPaneForLog(String logFileName, LogData logFileData, boolean signatureValid) {
        this.fileInfoLabel.setText(logFileName);
        this.cardLayout.show(this.cards, LOG_CARD_NAME);
        this.logFileCardPanel.update(logFileData, signatureValid);
        this.pack();
    }

    public void updateContentPaneForError(String filename) {
        this.fileInfoLabel.setText(filename);
        this.cardLayout.show(this.cards, EMPTY_CARD_NAME);
        this.pack();
    }

    public void updateContentPaneForSignatureCheckOnlyFile(String pdfFileName, boolean signatureValid) {
        this.cardLayout.show(this.cards, PDF_CARD_NAME);
        this.pdfFileCardPanel.upudate(signatureValid);
        this.fileInfoLabel.setText(pdfFileName);
        this.pack();
    }

    public void updateContentPaneForDirectory(BulkDirectoryProcessor bulkDirectoryProcessor) {
        this.fileInfoLabel.setText(bulkDirectoryProcessor.getDirectory().getPath());
        this.directoryCardPanel.update(bulkDirectoryProcessor);
        this.cardLayout.show(this.cards, DIRECTORY_CARD_NAME);
        this.pack();
    }

    public void addActionListener(ActionListener actionListener) {
        this.selectFileButton.addActionListener(actionListener);
        this.selectDirectoryButton.addActionListener(actionListener);
        this.logFileCardPanel.addActionListener(actionListener);
        this.directoryCardPanel.addActionListener(actionListener);
    }
}

