/*
 * Decompiled with CFR 0.152.
 */
package com.zuehlke.qtag.gui.ui;

import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JFrame;

public class MySaveDialog {
    private static final ResourceBundle rb = ResourceBundle.getBundle("i18n", Locale.getDefault());
    private FileDialog saveFileDialog;
    private String allowedFilenameExtension;

    public MySaveDialog(JFrame parentFrame, String titleResourceKey, final String allowedFilenameExtensions) {
        this.allowedFilenameExtension = allowedFilenameExtensions;
        this.saveFileDialog = new FileDialog((Frame)parentFrame, rb.getString(titleResourceKey), 1);
        this.saveFileDialog.setFilenameFilter(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name != null && name.toLowerCase().endsWith(allowedFilenameExtensions);
            }
        });
    }

    public File show(String suggestedFilename) {
        this.saveFileDialog.setFile(suggestedFilename);
        this.saveFileDialog.setVisible(true);
        String selectedFile = this.saveFileDialog.getFile();
        String selectedDir = this.saveFileDialog.getDirectory();
        if (selectedFile != null && selectedDir != null) {
            if (!selectedFile.toLowerCase().endsWith(this.allowedFilenameExtension)) {
                selectedFile = selectedFile + this.allowedFilenameExtension;
            }
            return new File(selectedDir + selectedFile);
        }
        return null;
    }
}

