/*
 * Decompiled with CFR 0.152.
 */
package com.zuehlke.qtag.gui.ui;

import com.zuehlke.qtag.gui.ui.LogFileCardPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

class PdfFileCardPanel
extends JPanel {
    private static final long serialVersionUID = 3538216133576140397L;
    private static final ResourceBundle rb = ResourceBundle.getBundle("i18n", Locale.getDefault());
    private JLabel pdfSigStatusImgLabel;
    private static final ImageIcon FAIL_ICON = new ImageIcon(LogFileCardPanel.class.getResource("/fail.png"), "failed");
    private static final ImageIcon OK_ICON = new ImageIcon(LogFileCardPanel.class.getResource("/ok.png"), "failed");

    public PdfFileCardPanel() {
        this.setLayout(new GridBagLayout());
        JLabel pdfSigStatusLabel = new JLabel(rb.getString("main.gui.status.signature"));
        this.add((Component)pdfSigStatusLabel, PdfFileCardPanel.createGridBagConstraint(0, 1, 0.1));
        this.pdfSigStatusImgLabel = new JLabel();
        this.pdfSigStatusImgLabel.setHorizontalAlignment(10);
        this.add((Component)this.pdfSigStatusImgLabel, PdfFileCardPanel.createGridBagConstraint(1, 1, 0.9));
    }

    private static GridBagConstraints createGridBagConstraint(int gridx, int gridy, double weightx) {
        return PdfFileCardPanel.createGridBagConstraint(gridx, gridy, weightx, 10, 2);
    }

    private static GridBagConstraints createGridBagConstraint(int gridx, int gridy, double weightx, int anchor, int fill) {
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(4, 8, 6, 8);
        c.fill = fill;
        c.gridx = gridx;
        c.gridy = gridy;
        c.weightx = weightx;
        c.weighty = 0.1;
        c.anchor = anchor;
        return c;
    }

    void upudate(boolean signatureValid) {
        this.pdfSigStatusImgLabel.setIcon(signatureValid ? OK_ICON : FAIL_ICON);
    }
}

