/*
 * Decompiled with CFR 0.152.
 */
package com.zuehlke.qtag.gui.ui;

import com.zuehlke.qtag.gui.util.ApplicationProperties;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UIHelper {
    private static final Log log = LogFactory.getLog(UIHelper.class);
    private static final ResourceBundle rb = ResourceBundle.getBundle("i18n", Locale.getDefault());

    public static void showWarningMessage(String messageKey, Object ... args) {
        String title;
        String message;
        try {
            message = MessageFormat.format(rb.getString(messageKey), args);
            title = rb.getString("error.general.title");
        }
        catch (MissingResourceException e) {
            message = "An unexpected error has occurred.";
            title = "Warning";
        }
        JOptionPane pane = new JOptionPane(message, 2);
        JDialog dialog = pane.createDialog(title);
        dialog.setAlwaysOnTop(true);
        dialog.setVisible(true);
        dialog.dispose();
    }

    public static void launchDefaultApplication(File file) {
        if (file == null) {
            return;
        }
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.OPEN)) {
            try {
                Desktop.getDesktop().open(file);
            }
            catch (IOException e) {
                throw new RuntimeException("no associated application or the associated application failed to be launched");
            }
        } else {
            throw new RuntimeException("unable to open file " + file.getAbsolutePath() + " in plattform's associated application");
        }
    }

    static {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            String lang = ApplicationProperties.getAppProperty("application.lang", "en");
            Locale.setDefault(new Locale(lang.toLowerCase()));
        }
        catch (Exception e) {
            log.warn("unable to set native look and feel: " + e);
        }
    }
}

