/*
 * Decompiled with CFR 0.152.
 */
package com.zuehlke.qtag.gui.util;

import java.util.Properties;

public abstract class ApplicationProperties {
    public static final String APPLICATION_PROPERTY_FILE = "application.properties";
    private static Properties properties = ApplicationProperties.loadProperties();

    private ApplicationProperties() {
    }

    public static String getAppProperty(String key, String defaultValue) {
        return properties.getProperty(key, defaultValue);
    }

    private static Properties loadProperties() {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Properties result = new Properties();
            result.load(loader.getResourceAsStream(APPLICATION_PROPERTY_FILE));
            return result;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not load application.properties as resource from classpath");
        }
    }
}

