/*
 * Decompiled with CFR 0.152.
 */
package com.zuehlke.qtag.gui.vaccinereport;

import com.zuehlke.qtag.parser.log.model.clmdoc.alarm.AlarmConfiguration;

final class AlarmConfigurationFormatter {
    public static String format(AlarmConfiguration alarmConfig) {
        int totalMinutes = alarmConfig.getTimeThresholdInMinutes();
        switch (alarmConfig.getType()) {
            case NONE: {
                return "";
            }
            case ACCUMULATED_ABOVE: {
                return String.format("> %s\u00b0C %s accumulated", Float.valueOf(alarmConfig.getTempThreshold()), AlarmConfigurationFormatter.formatTimeThreshold(totalMinutes));
            }
            case ACCUMULATED_BELOW: {
                return String.format("< %s\u00b0C %s accumulated", Float.valueOf(alarmConfig.getTempThreshold()), AlarmConfigurationFormatter.formatTimeThreshold(totalMinutes));
            }
            case SINGLE_ABOVE: {
                return String.format("> %s\u00b0C %s single event", Float.valueOf(alarmConfig.getTempThreshold()), AlarmConfigurationFormatter.formatTimeThreshold(totalMinutes));
            }
            case SINGLE_BELOW: {
                return String.format("< %s\u00b0C %s single event", Float.valueOf(alarmConfig.getTempThreshold()), AlarmConfigurationFormatter.formatTimeThreshold(totalMinutes));
            }
            case TTE: {
                throw new RuntimeException("TTE Alarms not supported in Vaccine Report");
            }
        }
        throw new RuntimeException("unknown AlarmConfiguration type: " + (Object)((Object)alarmConfig.getType()));
    }

    static String formatTimeThreshold(int totalMinutes) {
        int hours = totalMinutes / 60;
        int minutes = totalMinutes % 60;
        StringBuilder formattedTimeThreshold = new StringBuilder();
        if (hours != 0) {
            formattedTimeThreshold.append(hours).append("h");
        }
        if (minutes != 0) {
            if (hours != 0) {
                formattedTimeThreshold.append(" ");
            }
            formattedTimeThreshold.append(minutes).append("min");
        }
        return formattedTimeThreshold.toString();
    }

    public static String formatShort(AlarmConfiguration alarmConfig) {
        switch (alarmConfig.getType()) {
            case NONE: {
                return "---";
            }
            case ACCUMULATED_ABOVE: {
                return String.format(">%s\u00b0C", Float.valueOf(alarmConfig.getTempThreshold()));
            }
            case ACCUMULATED_BELOW: {
                return String.format("<%s\u00b0C", Float.valueOf(alarmConfig.getTempThreshold()));
            }
            case SINGLE_ABOVE: {
                return String.format(">%s\u00b0C", Float.valueOf(alarmConfig.getTempThreshold()));
            }
            case SINGLE_BELOW: {
                return String.format("<%s\u00b0C", Float.valueOf(alarmConfig.getTempThreshold()));
            }
            case TTE: {
                throw new RuntimeException("TTE Alarms not supported in Vaccine Report");
            }
        }
        throw new RuntimeException("unknown AlarmConfiguration type: " + (Object)((Object)alarmConfig.getType()));
    }

    private AlarmConfigurationFormatter() {
    }
}

