/*
 * Decompiled with CFR 0.152.
 */
package com.zuehlke.qtag.gui.vaccinereport;

import com.zuehlke.qtag.gui.vaccinereport.AlarmConfigurationFormatter;
import com.zuehlke.qtag.gui.vaccinereport.XSSFWorkbookUtils;
import com.zuehlke.qtag.parser.log.model.clmdoc.LogDataCLmdoc;
import com.zuehlke.qtag.parser.log.model.clmdoc.alarm.AccumulatedAlarm;
import com.zuehlke.qtag.parser.log.model.clmdoc.alarm.Alarm;
import com.zuehlke.qtag.parser.log.model.clmdoc.alarm.AlarmConfiguration;
import com.zuehlke.qtag.parser.log.model.clmdoc.alarm.AlarmType;
import com.zuehlke.qtag.parser.log.model.clmdoc.alarm.SingleEventAlarm;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class VaccineReport {
    public static final String VACCINE_REPORT_TEMPLATE_XLSX = "/Vaccine_Report_Template.xlsx";
    private static final String COUNTRY_FIELD_NAME = "country_field";
    private static final String TYPE_OF_VACCINE_FIELD_NAME = "type_of_vaccine_field";
    private static final Log log = LogFactory.getLog(VaccineReport.class);
    private XSSFWorkbook workbook;

    public static VaccineReport createNewFromTemplate(List<AlarmConfiguration> alarmConfigs, TimeZone page4TimeZone) throws IOException {
        VaccineReport vaccineReport = VaccineReport.createPlainFromTemplate();
        int index = 1;
        for (AlarmConfiguration alarmConfig : alarmConfigs) {
            if (index > 4) {
                log.warn("VAR can only hold 4 alarm configs, skipping: " + alarmConfig);
                continue;
            }
            if (alarmConfig.getType().equals((Object)AlarmType.NONE)) {
                throw new RuntimeException("NONE alarms are not supported in Vaccine Reports.");
            }
            if (alarmConfig.getType().equals((Object)AlarmType.TTE)) {
                throw new RuntimeException("TTE alarms are not supported in Vaccine Reports.");
            }
            vaccineReport.addAlarmConfiguration(alarmConfig, index);
            ++index;
        }
        String timeZoneId = page4TimeZone.getID();
        XSSFWorkbookUtils.replaceFirstInNamedCell(vaccineReport.workbook, "date_time_started_header", "TIMEZONE", timeZoneId);
        XSSFWorkbookUtils.replaceFirstInNamedCell(vaccineReport.workbook, "date_time_stopped_header", "TIMEZONE", timeZoneId);
        XSSFWorkbookUtils.replaceFirstInNamedCell(vaccineReport.workbook, "date_time_alarm1_header", "TIMEZONE", timeZoneId);
        XSSFWorkbookUtils.replaceFirstInNamedCell(vaccineReport.workbook, "date_time_alarm2_header", "TIMEZONE", timeZoneId);
        XSSFWorkbookUtils.replaceFirstInNamedCell(vaccineReport.workbook, "date_time_alarm3_header", "TIMEZONE", timeZoneId);
        XSSFWorkbookUtils.replaceFirstInNamedCell(vaccineReport.workbook, "date_time_alarm4_header", "TIMEZONE", timeZoneId);
        return vaccineReport;
    }

    static VaccineReport createPlainFromTemplate() throws IOException {
        InputStream inputStream = VaccineReport.class.getResourceAsStream(VACCINE_REPORT_TEMPLATE_XLSX);
        VaccineReport vaccineReport = new VaccineReport(new BufferedInputStream(inputStream));
        inputStream.close();
        return vaccineReport;
    }

    private void addAlarmConfiguration(AlarmConfiguration alarmConfig, int index) {
        if (index > 4 || index < 1) {
            throw new IllegalArgumentException("The vaccine report can only hold alarm config 1 till 4");
        }
        Cell headerCell = XSSFWorkbookUtils.findCellByName(this.workbook, "alarm" + index + "_def");
        String formatted = AlarmConfigurationFormatter.format(alarmConfig);
        headerCell.setCellValue(formatted);
        Cell headerCellShort = XSSFWorkbookUtils.findCellByName(this.workbook, "alarm" + index + "_short_header");
        String formattedShort = AlarmConfigurationFormatter.formatShort(alarmConfig);
        headerCellShort.setCellValue(formattedShort);
    }

    public VaccineReport(InputStream inputStream) throws IOException {
        this.workbook = new XSSFWorkbook(inputStream);
    }

    public VaccineReport(File file) throws IOException {
        this(new BufferedInputStream(new FileInputStream(file)));
    }

    public void addLogAlarms(String boxNumber, String vaccineLotNumber, LogDataCLmdoc logFileData, Calendar dateAndTimeOfInspection) {
        List<List<Alarm>> alarms = VaccineReport.getRelevantAlarms(logFileData);
        if (!this.doAlarmConfigsMatch(logFileData)) {
            throw new IllegalArgumentException("The configurations of the given alarms do not match the stored alarm configurations");
        }
        if (alarms.get(0).isEmpty() && alarms.get(1).isEmpty() && alarms.get(2).isEmpty() && alarms.get(3).isEmpty()) {
            return;
        }
        this.fillPage2(boxNumber, vaccineLotNumber, logFileData.getSerialNumber(), alarms, dateAndTimeOfInspection);
        for (int perConfigIndex = 0; perConfigIndex < 3; ++perConfigIndex) {
            Alarm alarm1 = this.getSingleAlarm(alarms, 0, perConfigIndex);
            Alarm alarm2 = this.getSingleAlarm(alarms, 1, perConfigIndex);
            Alarm alarm3 = this.getSingleAlarm(alarms, 2, perConfigIndex);
            Alarm alarm4 = this.getSingleAlarm(alarms, 3, perConfigIndex);
            if (alarm1 == null && alarm2 == null && alarm3 == null && alarm4 == null) continue;
            boolean isFirstAlarmForConfig = perConfigIndex == 0;
            Calendar started = logFileData.getResult().getTimestampStarted();
            if (started == null) {
                started = logFileData.getResult().getTimestampActivated();
            }
            this.insertNewPage4Row(boxNumber, logFileData.getSerialNumber(), started, logFileData.getResult().getTimestampStopped(), logFileData.getResult().getTransportTimeInDays(), alarm1, alarm2, alarm3, alarm4, isFirstAlarmForConfig);
        }
    }

    private static List<List<Alarm>> getRelevantAlarms(LogDataCLmdoc data) {
        ArrayList<List<Alarm>> alarms = new ArrayList<List<Alarm>>();
        for (AlarmConfiguration alarm : data.getConfiguration().getAlarmConfiguration()) {
            AlarmType alarmType = alarm.getType();
            if (alarmType.equals((Object)AlarmType.TTE) || alarmType.equals((Object)AlarmType.NONE)) continue;
            alarms.add(data.getResult().getAlarmsByIndex(alarm.getAlarmNumber(), false));
        }
        while (alarms.size() < 5) {
            alarms.add(new ArrayList(0));
        }
        return alarms;
    }

    public boolean doAlarmConfigsMatch(LogDataCLmdoc logFileData) {
        List<AlarmConfiguration> otherAlarmConfigs = VaccineReport.getVARRelevantAlarmConfigs(logFileData);
        int maxIndex = otherAlarmConfigs.size();
        if (maxIndex > 4) {
            maxIndex = 4;
        }
        for (int i = 1; i <= maxIndex; ++i) {
            AlarmConfiguration otherAlarmConfig = otherAlarmConfigs.get(i - 1);
            if (AlarmConfigurationFormatter.format(otherAlarmConfig).equals(this.getAlarmConfigurationString(i))) continue;
            return false;
        }
        return true;
    }

    public static List<AlarmConfiguration> getVARRelevantAlarmConfigs(LogDataCLmdoc data) {
        ArrayList<AlarmConfiguration> alarmConfigs = new ArrayList<AlarmConfiguration>(5);
        for (AlarmConfiguration alarm : data.getConfiguration().getAlarmConfiguration()) {
            AlarmType alarmType = alarm.getType();
            if (alarmType.equals((Object)AlarmType.TTE) || alarmType.equals((Object)AlarmType.NONE)) continue;
            alarmConfigs.add(alarm);
        }
        return alarmConfigs;
    }

    private String getAlarmConfigurationString(int index) {
        if (index > 4 || index < 1) {
            throw new IllegalArgumentException("index must be 1, 2, 3 or 4");
        }
        Cell cell = XSSFWorkbookUtils.findCellByName(this.workbook, "alarm" + index + "_def");
        return cell.getStringCellValue();
    }

    private void fillPage2(String boxNumber, String vaccineLotNumber, String electronicDeviceSerialNumber, List<List<Alarm>> alarms, Calendar dateAndTimeOfInspection) {
        Row statusRow = this.getNextFreeRowAfterNamedCell("first_status_details_box_number");
        statusRow.getCell(0).setCellValue(boxNumber);
        statusRow.getCell(2).setCellValue(vaccineLotNumber);
        statusRow.getCell(5).setCellValue(electronicDeviceSerialNumber);
        if (!alarms.get(0).isEmpty()) {
            statusRow.getCell(8).setCellValue("X");
        }
        if (!alarms.get(1).isEmpty()) {
            statusRow.getCell(10).setCellValue("X");
        }
        if (!alarms.get(2).isEmpty()) {
            statusRow.getCell(12).setCellValue("X");
        }
        if (!alarms.get(3).isEmpty()) {
            statusRow.getCell(14).setCellValue("X");
        }
        statusRow.getCell(20).setCellValue(VaccineReport.formatDateAndTimeOfInspection(dateAndTimeOfInspection));
    }

    private Row getNextFreeRowAfterNamedCell(String anchorCellName) {
        Cell cell = XSSFWorkbookUtils.findCellByName(this.workbook, anchorCellName);
        Row row = cell.getRow();
        while (!XSSFWorkbookUtils.isRowEmpty(row)) {
            if (row.getCell((int)row.getFirstCellNum()).getStringCellValue().contains("Continue")) {
                int rowNum = row.getRowNum();
                Sheet sheet = row.getSheet();
                sheet.shiftRows(rowNum, sheet.getLastRowNum(), 1);
                row = XSSFWorkbookUtils.createRowWithSameStyleAsAbove(rowNum, sheet);
                continue;
            }
            Sheet sheet = row.getSheet();
            int newRowNumber = row.getRowNum() + 1;
            row = sheet.getRow(newRowNumber);
        }
        return row;
    }

    static String formatDateAndTimeOfInspection(Calendar dateAndTimeOfInspection) {
        TimeZone timeZone = dateAndTimeOfInspection.getTimeZone();
        int effectiveOffsetInMillis = timeZone.getOffset(dateAndTimeOfInspection.getTimeInMillis());
        return String.format("%1$td.%1$tm.%1$tY %1$tH:%tM%2$+2.1f", dateAndTimeOfInspection, (double)effectiveOffsetInMillis / 3600000.0);
    }

    private Alarm getSingleAlarm(List<List<Alarm>> alarms, int configIndex, int alarmIndex) {
        if (alarms.get(configIndex).size() > alarmIndex) {
            return alarms.get(configIndex).get(alarmIndex);
        }
        return null;
    }

    private void insertNewPage4Row(String boxNumber, String electronicDeviceSerialNumber, Calendar started, Calendar stopped, int transportTimeInDays, Alarm alarm1, Alarm alarm2, Alarm alarm3, Alarm alarm4, boolean isFirstAlarmForConfig) {
        Row alarmRow = this.getNextFreeRowAfterNamedCell("alarm_report_first_box_number_field");
        if (isFirstAlarmForConfig) {
            alarmRow.getCell(0).setCellValue(boxNumber);
            alarmRow.getCell(2).setCellValue(electronicDeviceSerialNumber);
            if (!started.getTimeZone().equals(this.getPage4TimeZone())) {
                throw new RuntimeException("Timezone of started and the one configured in the column header does not match: started: '" + started.getTimeZone() + "', page4ColumnHeader: '" + this.getPage4TimeZone() + "'");
            }
            if (!stopped.getTimeZone().equals(this.getPage4TimeZone())) {
                throw new RuntimeException("Timezone of stopped and the one configured in the column header does not match: started: '" + stopped.getTimeZone() + "', page4ColumnHeader: '" + this.getPage4TimeZone() + "'");
            }
            alarmRow.getCell(6).setCellValue(started);
            alarmRow.getCell(10).setCellValue(stopped);
            alarmRow.getCell(14).setCellValue((double)transportTimeInDays);
        }
        this.fillPage4AlarmDetails(alarm1, alarmRow, 16);
        this.fillPage4AlarmDetails(alarm2, alarmRow, 24);
        this.fillPage4AlarmDetails(alarm3, alarmRow, 32);
        this.fillPage4AlarmDetails(alarm4, alarmRow, 40);
    }

    public TimeZone getPage4TimeZone() {
        Cell cell = XSSFWorkbookUtils.findCellByName(this.workbook, "date_time_started_header");
        Matcher matcher = Pattern.compile("\\((.*)\\)").matcher(cell.getStringCellValue());
        if (matcher.find()) {
            return TimeZone.getTimeZone(matcher.group(1));
        }
        throw new RuntimeException("Can not find Timezone regex in page4");
    }

    private void fillPage4AlarmDetails(Alarm alarm, Row alarmRow, int alarmColumnStartIndex) {
        if (alarm != null) {
            long durationInMinutes;
            Calendar alarmDate = alarm.getAlarmDate();
            if (!alarmDate.getTimeZone().equals(this.getPage4TimeZone())) {
                throw new RuntimeException("Timezone of the alarm and the one configured in the column header does not match: Alarm: '" + alarmDate.getTimeZone() + "', page4ColumnHeader: '" + this.getPage4TimeZone() + "'");
            }
            alarmRow.getCell(alarmColumnStartIndex).setCellValue(alarmDate);
            if (alarm instanceof SingleEventAlarm) {
                durationInMinutes = ((SingleEventAlarm)alarm).getAlarmDuration();
                alarmRow.getCell(alarmColumnStartIndex + 4).setCellValue(VaccineReport.formatDuration(durationInMinutes));
                alarmRow.getCell(alarmColumnStartIndex + 6).setCellValue((double)((SingleEventAlarm)alarm).getTempExtremeValue());
            }
            if (alarm instanceof AccumulatedAlarm) {
                durationInMinutes = ((AccumulatedAlarm)alarm).getAlarmDuration();
                alarmRow.getCell(alarmColumnStartIndex + 4).setCellValue(VaccineReport.formatDuration(durationInMinutes));
            }
        }
    }

    static String formatDuration(long durationInMinutes) {
        long minutesPart = durationInMinutes % 60L;
        long hoursPart = durationInMinutes / 60L;
        return String.format("%d:%02d", hoursPart, minutesPart);
    }

    public String getCountry() {
        return XSSFWorkbookUtils.getNamedCellValue(this.workbook, COUNTRY_FIELD_NAME);
    }

    public String getTypeOfVaccine() {
        return XSSFWorkbookUtils.getNamedCellValue(this.workbook, TYPE_OF_VACCINE_FIELD_NAME);
    }

    public void saveAs(File file) throws IOException {
        FileOutputStream stream = new FileOutputStream(file);
        this.saveTo(new BufferedOutputStream(stream));
    }

    public void saveTo(OutputStream stream) throws IOException {
        this.workbook.write(stream);
        stream.close();
    }

    public void setCountry(String country) {
        XSSFWorkbookUtils.setNamedCellValue(this.workbook, COUNTRY_FIELD_NAME, country);
    }

    public void setDateOfReport(Calendar dateOfReport) {
        Cell cell = XSSFWorkbookUtils.findCellByName(this.workbook, "date_of_report_field");
        cell.setCellValue(dateOfReport.getTime());
        double d = cell.getNumericCellValue();
        cell.setCellValue(Math.floor(d));
    }

    Date getDateOfReport() {
        Cell cell = XSSFWorkbookUtils.findCellByName(this.workbook, "date_of_report_field");
        return cell.getDateCellValue();
    }

    public void setTypeOfVaccine(String typeOfVaccine) {
        XSSFWorkbookUtils.setNamedCellValue(this.workbook, TYPE_OF_VACCINE_FIELD_NAME, typeOfVaccine);
    }
}

