/*
 * Decompiled with CFR 0.152.
 */
package com.zuehlke.qtag.gui.vaccinereport;

import com.zuehlke.qtag.gui.ui.MySaveDialog;
import com.zuehlke.qtag.gui.ui.UIHelper;
import com.zuehlke.qtag.gui.vaccinereport.VaccineReport;
import com.zuehlke.qtag.parser.log.model.clmdoc.LogDataCLmdoc;
import java.awt.AWTKeyStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VaccineReportDialog
extends JDialog {
    private static final long serialVersionUID = -5007039024097280332L;
    private static final Log log = LogFactory.getLog(VaccineReportDialog.class);
    private static final Vector<String> countries;
    private JPanel contentPane;
    private JButton cancelButton;
    private JTextField lotNrVaccineTextField;
    private JTextField boxNrTextField;
    private JComboBox<String> countryTextField;
    private JTextField typeOfVaccineTextField;
    private JButton saveButton;
    private JButton saveAsButton;
    private JLabel validationLabel;
    private VaccineReport vaccineReport;
    private LogDataCLmdoc logFileData;
    private File vaccineReportFile;
    private ResourceBundle resourceBundle = ResourceBundle.getBundle("i18n");

    public VaccineReportDialog(VaccineReport vaccineReport, File vaccineReportFile, LogDataCLmdoc logFileData) {
        this.$$$setupUI$$$();
        this.vaccineReport = vaccineReport;
        this.logFileData = logFileData;
        this.vaccineReportFile = vaccineReportFile;
        this.setTitle(this.resourceBundle.getString("vaccine.gui.title"));
        this.setContentPane(this.contentPane);
        this.setModal(true);
        this.getRootPane().setDefaultButton(null);
        this.addDefaultCancelHandling();
        this.addButtonListeners();
        if (vaccineReport.getCountry().isEmpty()) {
            this.countryTextField.setModel(new DefaultComboBoxModel<String>(countries));
        } else {
            this.countryTextField.setModel(new DefaultComboBoxModel<String>(new String[]{vaccineReport.getCountry()}));
            this.countryTextField.setEditable(false);
            this.countryTextField.setEnabled(false);
        }
        this.typeOfVaccineTextField.setText(vaccineReport.getTypeOfVaccine());
        if (!vaccineReport.getTypeOfVaccine().isEmpty()) {
            this.typeOfVaccineTextField.setEditable(false);
            this.typeOfVaccineTextField.setEnabled(false);
        }
        if (vaccineReportFile == null) {
            this.saveButton.setEnabled(false);
        }
        this.addEnterKeyForFocusTraversal(this.typeOfVaccineTextField);
        this.addEnterKeyForFocusTraversal(this.boxNrTextField);
        this.addEnterKeyForFocusTraversal(this.lotNrVaccineTextField);
        this.addEnterKeyForFocusTraversal(this.countryTextField);
    }

    private void addButtonListeners() {
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VaccineReportDialog.this.onCancel();
            }
        });
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VaccineReportDialog.this.onSave();
            }
        });
        this.saveAsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VaccineReportDialog.this.onSaveAs();
            }
        });
    }

    private void addDefaultCancelHandling() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                VaccineReportDialog.this.onCancel();
            }
        });
        this.contentPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VaccineReportDialog.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
    }

    private void onCancel() {
        this.dispose();
    }

    private void onSave() {
        if (this.countryTextField.getSelectedItem().toString().isEmpty() || this.typeOfVaccineTextField.getText().isEmpty() || this.boxNrTextField.getText().isEmpty() || this.lotNrVaccineTextField.getText().isEmpty()) {
            this.validationLabel.setText(this.resourceBundle.getString("vaccine.gui.label"));
            return;
        }
        this.ensureFileIsWritable();
        this.vaccineReport.setCountry(this.countryTextField.getSelectedItem().toString());
        this.vaccineReport.setTypeOfVaccine(this.typeOfVaccineTextField.getText());
        Calendar now = Calendar.getInstance();
        this.vaccineReport.setDateOfReport(now);
        this.vaccineReport.addLogAlarms(this.boxNrTextField.getText(), this.lotNrVaccineTextField.getText(), this.logFileData, now);
        try {
            this.vaccineReport.saveAs(this.vaccineReportFile);
            this.dispose();
            FileOutputStream fileOutputStream = new FileOutputStream(this.vaccineReportFile, true);
            UIHelper.launchDefaultApplication(this.vaccineReportFile);
            fileOutputStream.close();
        }
        catch (IOException e) {
            log.error("error during writing vaccine report", e);
            UIHelper.showWarningMessage("error.general", new Object[0]);
        }
    }

    private void ensureFileIsWritable() {
        while (true) {
            try {
                new FileOutputStream(this.vaccineReportFile).close();
            }
            catch (FileNotFoundException e) {
                UIHelper.showWarningMessage("file.save.error.locked", new Object[0]);
                continue;
            }
            catch (IOException e) {
                log.error(e, e);
                continue;
            }
            break;
        }
    }

    private void onSaveAs() {
        if (this.countryTextField.getSelectedItem().toString().isEmpty() || this.typeOfVaccineTextField.getText().isEmpty() || this.boxNrTextField.getText().isEmpty() || this.lotNrVaccineTextField.getText().isEmpty()) {
            this.validationLabel.setText(this.resourceBundle.getString("vaccine.gui.label"));
            return;
        }
        MySaveDialog saveAsDialog = new MySaveDialog(null, "file.save.title", ".xlsx");
        String filename = this.vaccineReportFile == null ? null : this.vaccineReportFile.getName();
        File newVaccineReportFile = saveAsDialog.show(filename);
        if (newVaccineReportFile != null) {
            this.vaccineReportFile = newVaccineReportFile;
            this.onSave();
        }
    }

    private void addEnterKeyForFocusTraversal(JComponent typeOfVaccineTextField) {
        HashSet<AWTKeyStroke> set = new HashSet<AWTKeyStroke>(typeOfVaccineTextField.getFocusTraversalKeys(0));
        set.add(KeyStroke.getKeyStroke("ENTER"));
        typeOfVaccineTextField.setFocusTraversalKeys(0, set);
    }

    public File getVaccineReportFile() {
        return this.vaccineReportFile;
    }

    private void $$$setupUI$$$() {
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new GridBagLayout());
        this.contentPane.setEnabled(true);
        this.contentPane.setForeground(new Color(-16777216));
        this.contentPane.setOpaque(true);
        this.contentPane.setPreferredSize(new Dimension(425, 265));
        this.contentPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10), null, 0, 0, null, new Color(-16777216)));
        JLabel label1 = new JLabel();
        this.$$$loadLabelText$$$(label1, ResourceBundle.getBundle("i18n").getString("vaccine.gui.label.country"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.1;
        gbc.weighty = 0.1;
        gbc.anchor = 17;
        gbc.ipadx = 5;
        gbc.ipady = 5;
        this.contentPane.add((Component)label1, gbc);
        JLabel label2 = new JLabel();
        this.$$$loadLabelText$$$(label2, ResourceBundle.getBundle("i18n").getString("vaccine.gui.label.vaccine"));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 0.1;
        gbc.weighty = 0.1;
        gbc.anchor = 17;
        gbc.ipadx = 5;
        gbc.ipady = 5;
        this.contentPane.add((Component)label2, gbc);
        JLabel label3 = new JLabel();
        this.$$$loadLabelText$$$(label3, ResourceBundle.getBundle("i18n").getString("vaccine.gui.label.boxnr"));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.weightx = 0.1;
        gbc.weighty = 0.1;
        gbc.anchor = 17;
        gbc.ipadx = 5;
        gbc.ipady = 5;
        this.contentPane.add((Component)label3, gbc);
        JLabel label4 = new JLabel();
        this.$$$loadLabelText$$$(label4, ResourceBundle.getBundle("i18n").getString("vaccine.gui.label.lotNrVaccine"));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.weightx = 0.1;
        gbc.weighty = 0.1;
        gbc.anchor = 17;
        gbc.ipadx = 5;
        gbc.ipady = 5;
        this.contentPane.add((Component)label4, gbc);
        this.lotNrVaccineTextField = new JTextField();
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 4;
        gbc.gridwidth = 3;
        gbc.weightx = 0.9;
        gbc.anchor = 17;
        gbc.fill = 2;
        this.contentPane.add((Component)this.lotNrVaccineTextField, gbc);
        this.boxNrTextField = new JTextField();
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 3;
        gbc.gridwidth = 4;
        gbc.weightx = 0.9;
        gbc.anchor = 17;
        gbc.fill = 2;
        this.contentPane.add((Component)this.boxNrTextField, gbc);
        this.countryTextField = new JComboBox();
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.weightx = 0.9;
        gbc.anchor = 17;
        gbc.fill = 2;
        this.contentPane.add(this.countryTextField, gbc);
        this.typeOfVaccineTextField = new JTextField();
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.weightx = 0.9;
        gbc.anchor = 17;
        gbc.fill = 2;
        this.contentPane.add((Component)this.typeOfVaccineTextField, gbc);
        JPanel panel1 = new JPanel();
        panel1.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.gridwidth = 3;
        gbc.weighty = 0.3;
        gbc.fill = 1;
        gbc.insets = new Insets(10, 0, 0, 0);
        this.contentPane.add((Component)panel1, gbc);
        this.saveButton = new JButton();
        this.$$$loadButtonText$$$(this.saveButton, ResourceBundle.getBundle("i18n").getString("vaccine.gui.button.save"));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 0, 10);
        panel1.add((Component)this.saveButton, gbc);
        this.saveAsButton = new JButton();
        this.$$$loadButtonText$$$(this.saveAsButton, ResourceBundle.getBundle("i18n").getString("vaccine.gui.button.saveAs"));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 17;
        panel1.add((Component)this.saveAsButton, gbc);
        this.cancelButton = new JButton();
        this.$$$loadButtonText$$$(this.cancelButton, ResourceBundle.getBundle("i18n").getString("vaccine.gui.button.cancel"));
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 13;
        gbc.insets = new Insets(0, 20, 0, 0);
        panel1.add((Component)this.cancelButton, gbc);
        this.validationLabel = new JLabel();
        this.validationLabel.setEnabled(true);
        this.validationLabel.setForeground(new Color(-65536));
        this.validationLabel.setHorizontalAlignment(2);
        this.validationLabel.setText("  ");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.anchor = 17;
        this.contentPane.add((Component)this.validationLabel, gbc);
        label1.setLabelFor(this.countryTextField);
        label2.setLabelFor(this.typeOfVaccineTextField);
        label3.setLabelFor(this.boxNrTextField);
        label4.setLabelFor(this.lotNrVaccineTextField);
    }

    private void $$$loadLabelText$$$(JLabel component, String text) {
        StringBuffer result = new StringBuffer();
        boolean haveMnemonic = false;
        char mnemonic = '\u0000';
        int mnemonicIndex = -1;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '&') {
                if (++i == text.length()) break;
                if (!haveMnemonic && text.charAt(i) != '&') {
                    haveMnemonic = true;
                    mnemonic = text.charAt(i);
                    mnemonicIndex = result.length();
                }
            }
            result.append(text.charAt(i));
        }
        component.setText(result.toString());
        if (haveMnemonic) {
            component.setDisplayedMnemonic(mnemonic);
            component.setDisplayedMnemonicIndex(mnemonicIndex);
        }
    }

    private void $$$loadButtonText$$$(AbstractButton component, String text) {
        StringBuffer result = new StringBuffer();
        boolean haveMnemonic = false;
        char mnemonic = '\u0000';
        int mnemonicIndex = -1;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '&') {
                if (++i == text.length()) break;
                if (!haveMnemonic && text.charAt(i) != '&') {
                    haveMnemonic = true;
                    mnemonic = text.charAt(i);
                    mnemonicIndex = result.length();
                }
            }
            result.append(text.charAt(i));
        }
        component.setText(result.toString());
        if (haveMnemonic) {
            component.setMnemonic(mnemonic);
            component.setDisplayedMnemonicIndex(mnemonicIndex);
        }
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    static {
        String[] countryCodes = Locale.getISOCountries();
        countries = new Vector(countryCodes.length);
        for (String countryCode : countryCodes) {
            countries.add(new Locale("en", countryCode).getDisplayCountry(new Locale("en")).toUpperCase());
        }
        Collections.sort(countries);
    }
}

