/*
 * Decompiled with CFR 0.152.
 */
package com.zuehlke.qtag.gui.vaccinereport;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFName;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

final class XSSFWorkbookUtils {
    private XSSFWorkbookUtils() {
    }

    static void setNamedCellValue(XSSFWorkbook workbook, String cellName, String newValue) {
        Cell cell = XSSFWorkbookUtils.findCellByName(workbook, cellName);
        cell.setCellValue(newValue);
    }

    static String getNamedCellValue(XSSFWorkbook workbook, String cellName) {
        Cell cell = XSSFWorkbookUtils.findCellByName(workbook, cellName);
        return cell.getStringCellValue();
    }

    static Cell findCellByName(XSSFWorkbook workbook, String cellName) {
        XSSFName xssfName = workbook.getName(cellName);
        if (xssfName == null) {
            throw new RuntimeException("Cell with name '" + cellName + "' could not be found in the excel file");
        }
        CellReference cellReference = new CellReference(xssfName.getRefersToFormula());
        XSSFSheet sheet = workbook.getSheet(cellReference.getSheetName());
        XSSFRow row = sheet.getRow(cellReference.getRow());
        return row.getCell((int)cellReference.getCol());
    }

    static Row createRowWithSameStyleAsAbove(int rowNum, Sheet sheet) {
        int i;
        Row row = sheet.createRow(rowNum);
        Row referenceRow = sheet.getRow(rowNum - 1);
        row.setHeight(referenceRow.getHeight());
        for (i = 0; i < referenceRow.getLastCellNum(); ++i) {
            Cell referenceCell = referenceRow.getCell(i);
            if (referenceCell == null) continue;
            Cell newCell = row.createCell(i);
            newCell.setBlank();
            newCell.setCellStyle(referenceCell.getCellStyle());
        }
        for (i = 0; i < sheet.getNumMergedRegions(); ++i) {
            CellRangeAddress mergedRegion = sheet.getMergedRegion(i);
            if (mergedRegion.getFirstRow() != referenceRow.getRowNum()) continue;
            sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum(), mergedRegion.getFirstColumn(), mergedRegion.getLastColumn()));
        }
        return row;
    }

    static boolean isRowEmpty(Row row) {
        for (Cell cell : row) {
            if (cell.getCellType() == CellType.BLANK) continue;
            if (cell.getCellType() == CellType.STRING) {
                if (cell.getStringCellValue().isEmpty()) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public static void replaceFirstInNamedCell(XSSFWorkbook workbook, String cellName, String searchRegEx, String replaceString) {
        Cell cell = XSSFWorkbookUtils.findCellByName(workbook, cellName);
        cell.setCellValue(cell.getStringCellValue().replaceFirst(searchRegEx, replaceString));
    }
}

