/*
 * Decompiled with CFR 0.152.
 */
package com.zuehlke.qtag.logfile;

import com.zuehlke.qtag.parser.log.LogFileParser;
import com.zuehlke.qtag.parser.log.LogFileParserCLmdoc;
import com.zuehlke.qtag.parser.log.LogFilePreParser;
import com.zuehlke.qtag.parser.log.LogFileReader;
import com.zuehlke.qtag.parser.log.model.LogData;
import com.zuehlke.qtag.parser.log.model.LogFileRawData;
import com.zuehlke.qtag.parser.log.model.clmdoc.LogDataCLmdoc;
import java.io.File;

public class LogFileReaderVerifier {
    public static LogData readLogFileData(File file) throws Exception {
        LogFileReader logFileReader = new LogFileReader(file);
        LogFileRawData logFileRawData = logFileReader.getLogFileRawData();
        if (LogFilePreParser.isErrorLogFile(logFileRawData)) {
            throw new RuntimeException("This log file is an error log file.");
        }
        if (LogFilePreParser.isEncryptedLogFile(logFileRawData)) {
            throw new RuntimeException("This log file is encrypted and cannot be parsed.");
        }
        LogFileParser logFileParser = LogFilePreParser.getLogFileParser(logFileRawData);
        LogData data = null;
        data = logFileParser instanceof LogFileParserCLmdoc ? LogFileReaderVerifier.readLogFileDataCLmdoc((LogFileParserCLmdoc)logFileParser, logFileRawData) : logFileParser.parse();
        return data;
    }

    private static LogDataCLmdoc readLogFileDataCLmdoc(LogFileParserCLmdoc logFileParserCLmdoc, LogFileRawData logFileRawData) throws Exception {
        if (!LogFilePreParser.conaintsResultSection(logFileRawData)) {
            throw new RuntimeException("This log file contains no result section. Device was not yet started.");
        }
        return logFileParserCLmdoc.parse();
    }
}

