/*
 * Decompiled with CFR 0.152.
 */
package com.zuehlke.qtag.parser.log;

import com.zuehlke.qtag.parser.log.LogFileReader;
import com.zuehlke.qtag.parser.log.MissingKeyException;
import com.zuehlke.qtag.parser.log.UnsupportedLogFileException;
import com.zuehlke.qtag.parser.log.model.ILogFileKey;
import com.zuehlke.qtag.parser.log.model.LogData;
import com.zuehlke.qtag.parser.log.model.LogFileKey;
import com.zuehlke.qtag.parser.log.model.LogFileRawData;
import com.zuehlke.qtag.parser.log.model.QtagDevices;
import com.zuehlke.qtag.parser.log.model.clmdoc.LogFileKeyCLmdoc;
import com.zuehlke.qtag.util.CalendarUtils;
import java.io.InputStream;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTimeZone;

public class LogFileParser {
    private static final Log log = LogFactory.getLog(LogFileParser.class);
    private static final Set<ILogFileKey> obligatoryKeys = new HashSet<LogFileKey>(Arrays.asList(LogFileKey.DEVICE, LogFileKey.SERIAL));
    protected LogData logData = new LogData();
    protected LogFileRawData logFileRawData = new LogFileRawData();

    public LogFileParser(LogFileRawData logFileRawData) {
        if (logFileRawData == null) {
            throw new IllegalArgumentException("logFileRawData can not be null.");
        }
        this.logFileRawData = logFileRawData;
    }

    protected void loadDefaultValues(String fileName) {
        HashMap<String, ArrayList<String>> keyValueData = this.logFileRawData.getKeyValueData();
        HashMap<String, ArrayList<String>> origData = new HashMap<String, ArrayList<String>>(keyValueData);
        try {
            InputStream in = this.getClass().getResourceAsStream(fileName);
            LogFileReader logFileReader = new LogFileReader(in);
            keyValueData.clear();
            keyValueData.putAll(logFileReader.getLogFileRawData().getKeyValueData());
            keyValueData.putAll(origData);
        }
        catch (Exception e) {
            log.error("Default values could not be loaded from default log file.");
        }
    }

    public boolean containsAllKeys(Set<ILogFileKey> keys) {
        return this.getMissingKeys(keys).isEmpty();
    }

    public Set<ILogFileKey> getMissingKeys(Set<ILogFileKey> keys) {
        HashSet<ILogFileKey> missingKeys = new HashSet<ILogFileKey>();
        for (ILogFileKey key : keys) {
            boolean keyAvailable = false;
            for (String keyName : key.getKeyNames()) {
                if (!this.logFileRawData.getKeyValueData().containsKey(keyName)) continue;
                keyAvailable = true;
                break;
            }
            if (keyAvailable) continue;
            missingKeys.add(key);
        }
        return missingKeys;
    }

    public LogData parse() throws MissingKeyException, UnsupportedLogFileException {
        Set<ILogFileKey> missingKeys = this.getMissingKeys(obligatoryKeys);
        if (!missingKeys.isEmpty()) {
            throw new MissingKeyException(missingKeys);
        }
        this.parseLogFile();
        return this.logData;
    }

    private void parseLogFile() throws UnsupportedLogFileException {
        QtagDevices device = QtagDevices.getDeviceFromString(this.getValueFromKey(LogFileKey.DEVICE));
        if (!this.deviceSupported(device)) {
            throw new UnsupportedLogFileException("Wrong device for this parser.");
        }
        this.logData.setQtagDevice(device);
        this.logData.setSerialNumber(this.getValueFromKey(LogFileKey.SERIAL));
        this.logData.setFwVersion(this.getValueFromKey(LogFileKey.FIRMWARE_VERSION));
        this.parseCertificateSection();
        this.logData.getSignature().setCertSignature(this.getValueFromKey(LogFileKey.CERTIFICATE_SIGNATURE));
        this.logData.getSignature().setContentSignature(this.getValueFromKey(LogFileKeyCLmdoc.SIGNATURE));
    }

    protected boolean deviceSupported(QtagDevices device) {
        return EnumSet.of(QtagDevices.CLmdoc, QtagDevices.FT2).contains((Object)device);
    }

    protected void parseCertificateSection() {
        this.logData.getSignature().getCertificate().setVersion(this.getValueFromKey(LogFileKey.CERTIFICATE_VERSION));
        this.logData.getSignature().getCertificate().setLot(this.getValueFromKey(LogFileKey.CERTIFICATE_LOT));
        this.logData.getSignature().getCertificate().setIssuer(this.getValueFromKey(LogFileKey.CERTIFICATE_ISSUER));
        this.logData.getSignature().getCertificate().setValidFromTimestamp(this.parseCalendarFromTimestamp(this.getValueFromKey(LogFileKey.CERTIFICATE_VALID_FROM), TimeZone.getTimeZone("GMT")));
        this.logData.getSignature().getCertificate().setOwner(this.getValueFromKey(LogFileKey.CERTIFICATE_OWNER));
        this.logData.getSignature().getCertificate().setPublicKey(this.getValueFromKey(LogFileKey.CERTIFICATE_PUBLICKEY));
    }

    protected String getValueFromKeyWithParam(ILogFileKey logFileKey, int index, Object ... args) {
        for (String key : logFileKey.getKeyNames()) {
            String value = this.getValue(key = String.format(key, args), index);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    protected String getValueFromKey(ILogFileKey logFileKey) {
        return this.getValue(logFileKey, 0);
    }

    protected String getValue(ILogFileKey logFileKey, int index) {
        for (String key : logFileKey.getKeyNames()) {
            String value = this.getValue(key, index);
            if (value == null) continue;
            return value;
        }
        log.info("Key \"" + logFileKey.getKeyNames() + "\" not available.");
        return null;
    }

    protected String getValue(String key, int index) {
        HashMap<String, ArrayList<String>> keyValueData = this.logFileRawData.getKeyValueData();
        ArrayList<String> arrayList = keyValueData.get(key);
        if (arrayList == null) {
            return null;
        }
        if (arrayList.size() < index) {
            return null;
        }
        return arrayList.get(index);
    }

    protected int parseInteger(String value) {
        if (value == null) {
            return 0;
        }
        if (value.isEmpty()) {
            return 0;
        }
        return Integer.parseInt(value);
    }

    protected int parseInteger(ILogFileKey key) {
        return this.parseInteger(this.getValueFromKey(key));
    }

    protected boolean parseBoolean(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value may not be null.");
        }
        if (value.isEmpty()) {
            throw new IllegalArgumentException("Value may not be empty.");
        }
        return value.equals("1");
    }

    protected boolean parseBoolean(ILogFileKey key) {
        return this.parseBoolean(this.getValueFromKey(key));
    }

    protected float parseFloat(String value) {
        if (value == null || value.contains("--.-")) {
            return Float.NaN;
        }
        return Float.parseFloat(value);
    }

    protected float parseFloat(ILogFileKey key) {
        return this.parseFloat(this.getValueFromKey(key));
    }

    protected Calendar parseCalendarFromTimestamp(String value, TimeZone timezone) {
        if (timezone == null) {
            timezone = TimeZone.getTimeZone("GMT");
        }
        if (value == null) {
            return null;
        }
        return CalendarUtils.parseAsCalendar(value, timezone);
    }

    protected Calendar parseCalendarFromDate(String date, TimeZone timezone) {
        if (timezone == null) {
            timezone = TimeZone.getTimeZone("GMT");
        }
        if (date == null) {
            return null;
        }
        return CalendarUtils.parseAsCalendarFromDate(date, timezone);
    }

    protected LocalTime parseLocalTime(String time) {
        return CalendarUtils.parseAsLocalTime(time);
    }

    protected LocalDate parseLocalDate(String date) {
        return CalendarUtils.parseAsLocalDate(date);
    }

    protected TimeZone parseTimezone(String value) {
        float offsetToGMTinHours = Float.parseFloat(value);
        int offsetToGMTInMillis = (int)(offsetToGMTinHours * 1000.0f * 3600.0f);
        TimeZone timezone = offsetToGMTInMillis == 0 ? TimeZone.getTimeZone("GMT") : DateTimeZone.forOffsetMillis(offsetToGMTInMillis).toTimeZone();
        return timezone;
    }

    protected TimeZone parseTimezone(ILogFileKey key) {
        return this.parseTimezone(this.getValueFromKey(key));
    }
}

