/*
 * Decompiled with CFR 0.152.
 */
package com.zuehlke.qtag.parser.log;

import com.zuehlke.qtag.parser.log.LogFileParser;
import com.zuehlke.qtag.parser.log.MissingKeyException;
import com.zuehlke.qtag.parser.log.UnsupportedLogFileException;
import com.zuehlke.qtag.parser.log.model.ErrorQtagDevices;
import com.zuehlke.qtag.parser.log.model.ILogFileKey;
import com.zuehlke.qtag.parser.log.model.LogFileKey;
import com.zuehlke.qtag.parser.log.model.LogFileRawData;
import com.zuehlke.qtag.parser.log.model.QtagDevices;
import com.zuehlke.qtag.parser.log.model.clmdoc.Configuration;
import com.zuehlke.qtag.parser.log.model.clmdoc.ConfigurationFlagsV1_0;
import com.zuehlke.qtag.parser.log.model.clmdoc.ConfigurationFlagsV1_6;
import com.zuehlke.qtag.parser.log.model.clmdoc.ConfigurationFlagsV1_7;
import com.zuehlke.qtag.parser.log.model.clmdoc.DevicesCLmdoc;
import com.zuehlke.qtag.parser.log.model.clmdoc.IConfigurationFlags;
import com.zuehlke.qtag.parser.log.model.clmdoc.LogDataCLmdoc;
import com.zuehlke.qtag.parser.log.model.clmdoc.LogFileKeyCLmdoc;
import com.zuehlke.qtag.parser.log.model.clmdoc.LogFileVersionCLmdoc;
import com.zuehlke.qtag.parser.log.model.clmdoc.LogPointCLmdoc;
import com.zuehlke.qtag.parser.log.model.clmdoc.Marker;
import com.zuehlke.qtag.parser.log.model.clmdoc.alarm.AccumulatedAlarm;
import com.zuehlke.qtag.parser.log.model.clmdoc.alarm.AlarmConfiguration;
import com.zuehlke.qtag.parser.log.model.clmdoc.alarm.SingleEventAlarm;
import com.zuehlke.qtag.parser.log.model.clmdoc.alarm.TTEAlarm;
import com.zuehlke.qtag.util.CalendarUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.TimeZone;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LogFileParserCLmdoc
extends LogFileParser {
    private static final String DEFAULT_FILE_RESSOURCE = "DefaultValuesCLmdoc.txt";
    protected LogDataCLmdoc logData = new LogDataCLmdoc();
    private static final Set<ILogFileKey> obligatoryKeys = new HashSet<ILogFileKey>(Arrays.asList(LogFileKey.DEVICE, LogFileKey.SERIAL, LogFileKeyCLmdoc.TIMEZONE, LogFileKeyCLmdoc.LOG_INTERVAL, LogFileKeyCLmdoc.RESTARTABLE_OPTIONS));

    public LogFileParserCLmdoc(LogFileRawData logFileRawData) {
        super(logFileRawData);
        this.loadDefaultValues(DEFAULT_FILE_RESSOURCE);
    }

    @Override
    public LogDataCLmdoc parse() throws MissingKeyException, UnsupportedLogFileException {
        Set<ILogFileKey> missingKeys = this.getMissingKeys(obligatoryKeys);
        this.logData = new LogDataCLmdoc(super.parse());
        if (!missingKeys.isEmpty()) {
            throw new MissingKeyException(missingKeys);
        }
        this.parseLogFile();
        return this.logData;
    }

    private void parseLogFile() throws UnsupportedLogFileException {
        DevicesCLmdoc device = DevicesCLmdoc.getDeviceFromString(this.getValueFromKey(LogFileKey.DEVICE));
        LogFileVersionCLmdoc version = LogFileVersionCLmdoc.fromString(this.getValueFromKey(LogFileKeyCLmdoc.VERSION));
        if (!this.deviceSupported(device)) {
            throw new UnsupportedLogFileException("Unsupported Device.");
        }
        if (!version.isSupported()) {
            throw new UnsupportedLogFileException("Unsupported log file version: " + version.toString() + ".");
        }
        this.logData.setDevice(device);
        this.logData.setLogFileVersion(version);
        this.logData.setDeviceId(this.parseInteger(LogFileKeyCLmdoc.DEVICE_ID));
        this.logData.setSensorNumber(this.parseInteger(LogFileKeyCLmdoc.SENSOR));
        this.logData.setSerialNumber(this.getValueFromKey(LogFileKey.SERIAL));
        this.parseConfiguration();
        this.parseResult();
        this.parseMarkerSection();
        this.parseDataSection();
        this.parseErrorSection();
    }

    @Override
    protected boolean deviceSupported(QtagDevices device) {
        return EnumSet.of(QtagDevices.CLmdoc).contains((Object)device);
    }

    private boolean deviceSupported(DevicesCLmdoc device) {
        EnumSet<DevicesCLmdoc> supportedDevices = EnumSet.complementOf(EnumSet.of(DevicesCLmdoc.Unspecified));
        return supportedDevices.contains((Object)device);
    }

    private void parseConfiguration() {
        Configuration config = this.logData.getConfiguration();
        config.setConfigurationId(this.getValueFromKey(LogFileKeyCLmdoc.CID));
        config.setLotId(this.getValueFromKey(LogFileKeyCLmdoc.LOT));
        config.setTimeZone(this.parseTimezone(LogFileKeyCLmdoc.TIMEZONE));
        config.setStartDelay(this.parseInteger(LogFileKeyCLmdoc.START_DELAY));
        config.setMaxTransportDuration(this.parseInteger(LogFileKeyCLmdoc.MAX_TRANSPORTATION_DAYS));
        config.setMovingAverageInterval(this.parseInteger(LogFileKeyCLmdoc.MOVING_AVERAGE));
        config.setMktEnergy(this.parseFloat(LogFileKeyCLmdoc.MKT_ENERGY));
        config.setToleranceAboveUpperLimit(this.parseFloat(LogFileKeyCLmdoc.TOLERANCE_ABOVE_UPPER_LIMIT));
        config.setToleranceBelowLowerLimit(this.parseFloat(LogFileKeyCLmdoc.TOLERANCE_BELOW_LOWER_LIMIT));
        config.setToleranceWithinLimit(this.parseFloat(LogFileKeyCLmdoc.TOLERANCE_WITHIN_LIMITS));
        config.setBatteryWarningLimit(this.parseFloat(LogFileKeyCLmdoc.BATTERY_WARNING_LIMIT));
        config.setTemperatureOffset(this.parseFloat(LogFileKeyCLmdoc.TEMPERATURE_OFFSET));
        this.parseConfigurationFlags();
        this.parseUserStrings();
        this.parseAlarmConfiguration();
        config.setTestResult(this.parseInteger(LogFileKeyCLmdoc.TEST_RES));
        config.setTestTimestamp(this.parseCalendar(this.getValueFromKey(LogFileKeyCLmdoc.TEST_TS)));
        config.setLogInterval(this.parseInteger(LogFileKeyCLmdoc.LOG_INTERVAL));
    }

    private void parseConfigurationFlags() {
        IConfigurationFlags configurationFlagInterface;
        int detReport = this.parseInteger(this.getValueFromKey(LogFileKeyCLmdoc.DETAILED_REPORT));
        int dispAndAlgOptions = this.parseInteger(this.getValueFromKey(LogFileKeyCLmdoc.DISP_AND_ALG_OPTIONS));
        int restartableOptions = this.parseInteger(this.getValueFromKey(LogFileKeyCLmdoc.RESTARTABLE_OPTIONS));
        if (this.logData.getLogFileVersion().isSameOrNewerLogFileVersion(LogFileVersionCLmdoc.V1_7)) {
            int expiration = this.parseInteger(this.getValueFromKey(LogFileKeyCLmdoc.EXPIRED));
            configurationFlagInterface = new ConfigurationFlagsV1_7(detReport, dispAndAlgOptions, restartableOptions, expiration);
        } else {
            configurationFlagInterface = this.logData.getLogFileVersion().isSameOrNewerLogFileVersion(LogFileVersionCLmdoc.V1_6) ? new ConfigurationFlagsV1_6(detReport, dispAndAlgOptions, restartableOptions) : new ConfigurationFlagsV1_0(detReport);
        }
        this.logData.getConfiguration().setConfigurationFlags(configurationFlagInterface);
    }

    private void parseUserStrings() {
        String[] userStrings = new String[3];
        for (int i = 0; i < 3; ++i) {
            userStrings[i] = this.getValueFromKeyWithParam(LogFileKeyCLmdoc.USER_STRING, 0, i + 1);
        }
        this.logData.getConfiguration().setUserString(userStrings);
    }

    private void parseAlarmConfiguration() {
        ArrayList<AlarmConfiguration> alarmConfigurations = new ArrayList<AlarmConfiguration>(5);
        for (int i = 1; i <= 5; ++i) {
            String timeThreshold;
            String tempThreshold;
            String type = this.getValueFromKeyWithParam(LogFileKeyCLmdoc.ALARM_TYPE, 0, i);
            if (type == null) continue;
            if (type.equals("5")) {
                tempThreshold = this.getValueFromKeyWithParam(LogFileKeyCLmdoc.TTE_TEMPERATURE_THRESHOLD, 0, i);
                timeThreshold = this.getValueFromKeyWithParam(LogFileKeyCLmdoc.TTE_THRESHOLD, 0, i);
            } else {
                tempThreshold = this.getValueFromKeyWithParam(LogFileKeyCLmdoc.ALARM_TEMPERATURE_THRESHOLD, 0, i);
                timeThreshold = this.getValueFromKeyWithParam(LogFileKeyCLmdoc.ALARM_TIME_THRESHOLD, 0, i);
            }
            if (tempThreshold == null || timeThreshold == null) continue;
            alarmConfigurations.add(AlarmConfiguration.parseFromString(type, tempThreshold, timeThreshold, i));
        }
        this.logData.getConfiguration().setAlarmConfiguration(alarmConfigurations);
    }

    private void parseResult() {
        this.logData.getResult().setTimestampActivated(this.parseCalendar(this.getValueFromKey(LogFileKeyCLmdoc.TIMESTAMP_ACTIVATION)));
        this.logData.getResult().setTimestampStarted(this.parseCalendar(this.getValueFromKey(LogFileKeyCLmdoc.TIMESTAMP_START)));
        this.logData.getResult().setTimestampStopped(this.parseCalendar(this.getValueFromKey(LogFileKeyCLmdoc.TIMESTAMP_STOP)));
        this.logData.getResult().setTransportTimeInDays(this.parseInteger(this.getValueFromKey(LogFileKeyCLmdoc.TRANSPORT_TIME)));
        this.logData.getResult().setTimestampBattTemp(this.parseCalendar(this.getValueFromKey(LogFileKeyCLmdoc.TIMESTAMP_BATTERY_TEMPERATURE)));
        this.logData.getResult().setTimestampBattCrit(this.parseCalendar(this.getValueFromKey(LogFileKeyCLmdoc.TIMESTAMP_BATTERY_CRITICAL)));
        this.logData.getResult().setMinT(this.parseFloat(this.getValueFromKey(LogFileKeyCLmdoc.TEMPERATURE_MINIMUM)));
        this.logData.getResult().setMaxT(this.parseFloat(this.getValueFromKey(LogFileKeyCLmdoc.TEMPERATURE_MAXIMUM)));
        this.logData.getResult().setTsMinT(this.parseCalendar(this.getValueFromKey(LogFileKeyCLmdoc.TIMESTAMP_TEMPERATURE_MINIMUM)));
        this.logData.getResult().setTsMaxT(this.parseCalendar(this.getValueFromKey(LogFileKeyCLmdoc.TIMESTAMP_TEMPERATURE_MAXIMUM)));
        this.logData.getResult().setMkt(this.parseFloat(this.getValueFromKey(LogFileKeyCLmdoc.MKT)));
        this.logData.getResult().setAvrgT(this.parseFloat(this.getValueFromKey(LogFileKeyCLmdoc.TEMPERATURE_AVERAGE)));
        this.parseAlarmResult();
    }

    private void parseAlarmResult() {
        for (AlarmConfiguration alarmConfig : this.logData.getConfiguration().getAlarmConfiguration()) {
            int alarmNr = alarmConfig.getAlarmNumber();
            String key = String.format("Res.Alarm.%d.TS S", alarmNr);
            int nrOfAlarmsOccured = this.getNumberOfValueStrings(key);
            block7: for (int i = 0; i < nrOfAlarmsOccured; ++i) {
                switch (alarmConfig.getType()) {
                    case ACCUMULATED_ABOVE: 
                    case ACCUMULATED_BELOW: {
                        this.logData.getResult().addAlarm(this.parseAccumulatedAlarm(alarmConfig, alarmNr, i));
                        continue block7;
                    }
                    case NONE: {
                        continue block7;
                    }
                    case SINGLE_ABOVE: 
                    case SINGLE_BELOW: {
                        this.logData.getResult().addAlarm(this.parseSingleEventAlarm(alarmConfig, alarmNr, i));
                        continue block7;
                    }
                    case TTE: {
                        this.logData.getResult().addAlarm(this.parseTTEAlarm(alarmConfig, alarmNr, i));
                        continue block7;
                    }
                }
            }
        }
    }

    @NotNull
    private SingleEventAlarm parseSingleEventAlarm(AlarmConfiguration alarmConfig, int alarmNr, int alarmIdx) {
        SingleEventAlarm singleEventAlarm = new SingleEventAlarm(alarmConfig, alarmNr);
        singleEventAlarm.setAlarmStartDate(this.parseCalendar(this.getValueFromKeyWithParam(LogFileKeyCLmdoc.TIMESTAMP_ALARM_START, alarmIdx, alarmNr)));
        singleEventAlarm.setAlarmDate(this.parseCalendar(this.getValueFromKeyWithParam(LogFileKeyCLmdoc.TIMESTAMP_ALARM, alarmIdx, alarmNr)));
        singleEventAlarm.setAlarmEndDate(this.parseCalendar(this.getValueFromKeyWithParam(LogFileKeyCLmdoc.TIMESTAMP_ALARM_END, alarmIdx, alarmNr)));
        singleEventAlarm.setAlarmDuration(this.parseInteger(this.getValueFromKeyWithParam(LogFileKeyCLmdoc.ALARM_DURATION, alarmIdx, alarmNr)));
        singleEventAlarm.setTempExtremeDate(this.parseCalendar(this.getValueFromKeyWithParam(LogFileKeyCLmdoc.TIMESTAMP_TEMPERATURE_EXTREMUM, alarmIdx, alarmNr)));
        singleEventAlarm.setTempExtremeValue(this.parseFloat(this.getValueFromKeyWithParam(LogFileKeyCLmdoc.TEMPERATURE_EXTREMUM, alarmIdx, alarmNr)));
        return singleEventAlarm;
    }

    @NotNull
    private AccumulatedAlarm parseAccumulatedAlarm(AlarmConfiguration alarmConfig, int alarmNr, int alarmIdx) {
        AccumulatedAlarm accumulatedAlarm = new AccumulatedAlarm(alarmConfig, alarmNr);
        accumulatedAlarm.setAlarmStartDate(this.parseCalendar(this.getValueFromKeyWithParam(LogFileKeyCLmdoc.TIMESTAMP_ALARM_START, alarmIdx, alarmNr)));
        accumulatedAlarm.setAlarmDate(this.parseCalendar(this.getValueFromKeyWithParam(LogFileKeyCLmdoc.TIMESTAMP_ALARM, alarmIdx, alarmNr)));
        accumulatedAlarm.setAlarmDuration(this.parseInteger(this.getValueFromKeyWithParam(LogFileKeyCLmdoc.ALARM_DURATION, alarmIdx, alarmNr)));
        return accumulatedAlarm;
    }

    @NotNull
    private TTEAlarm parseTTEAlarm(AlarmConfiguration alarmConfig, int alarmNr, int alarmIdx) {
        TTEAlarm tteAlarm = new TTEAlarm(alarmConfig, alarmNr);
        tteAlarm.setAlarmStartDate(this.parseCalendar(this.getValueFromKeyWithParam(LogFileKeyCLmdoc.TIMESTAMP_ALARM_START, alarmIdx, alarmNr)));
        tteAlarm.setAlarmDate(this.parseCalendar(this.getValueFromKeyWithParam(LogFileKeyCLmdoc.TIMESTAMP_ALARM, alarmIdx, alarmNr)));
        tteAlarm.setTteValue(this.parseInteger(this.getValueFromKeyWithParam(LogFileKeyCLmdoc.TTE_VALUE, alarmIdx, alarmNr)));
        return tteAlarm;
    }

    private void parseDataSection() {
        String[] header;
        ArrayList<String[]> logpoints = this.logFileRawData.getTabSeparatedData().get("Data");
        if (logpoints != null && (header = logpoints.get(0))[0].equals("yyyy-MM-dd hh:mm") && header[1].equals("T") && header[2].equals("Out of limits")) {
            logpoints.remove(0);
            for (String[] logpoint : logpoints) {
                LogPointCLmdoc logPoint2 = this.parseLogPoint(logpoint);
                if (logPoint2 == null) continue;
                this.logData.getLogPoints().add(logPoint2);
            }
        }
    }

    private void parseMarkerSection() {
        String[] header;
        ArrayList<String[]> markers = this.logFileRawData.getTabSeparatedData().get("Marker");
        if (markers != null && (header = markers.get(0))[0].equals("Number") && header[1].equals("T") && header[2].equals("yyyy-MM-dd hh:mm")) {
            markers.remove(0);
            for (String[] marker : markers) {
                Marker marker2 = this.parseMarker(marker);
                if (marker2 == null) continue;
                this.logData.getMarkers().add(marker2);
            }
        }
    }

    private void parseErrorSection() {
        if (this.logFileRawData.containsErrors()) {
            for (int i = 0; i < 99; ++i) {
                String key = String.format("Error.%d.Err Count", i);
                if (!this.logFileRawData.getKeyValueData().containsKey(key)) continue;
                int errorCount = this.parseInteger(this.getValueFromKeyWithParam(LogFileKeyCLmdoc.ERR_COUNT, 0, i));
                Calendar calendar = this.parseCalendar(this.getValueFromKeyWithParam(LogFileKeyCLmdoc.ERR_TIMESTAMP, 0, i));
                if (calendar == null) continue;
                this.logData.getErrors().add(new ErrorQtagDevices(i, errorCount, calendar));
            }
        }
    }

    @Nullable
    private Marker parseMarker(@NotNull String[] strings) {
        if (strings.length >= 3) {
            String name = strings[0];
            float temperature = Float.parseFloat(strings[1]);
            Calendar calendar = CalendarUtils.parseAsCalendar(strings[2], this.logData.getConfiguration().getTimeZone());
            return new Marker(name, calendar, temperature);
        }
        return null;
    }

    private int getNumberOfValueStrings(String key) {
        ArrayList<String> arrayList = this.logFileRawData.getKeyValueData().get(key);
        if (arrayList == null) {
            return 0;
        }
        return arrayList.size();
    }

    private Calendar parseCalendar(String value) {
        TimeZone timeZone = this.logData.getConfiguration().getTimeZone();
        if (timeZone == null) {
            throw new IllegalArgumentException("Timezone not initialized");
        }
        return this.parseCalendarFromTimestamp(value, timeZone);
    }

    private LogPointCLmdoc parseLogPoint(String[] strings) {
        return this.parseLogPoint(strings, this.logData.getConfiguration().getTimeZone());
    }

    protected LogPointCLmdoc parseLogPoint(@NotNull String[] strings, TimeZone timezone) {
        boolean outOfLimits = false;
        if (strings.length >= 2) {
            Calendar calendar = CalendarUtils.parseAsCalendar(strings[0], timezone);
            float temperature = strings[1].equals("--.-") ? Float.NaN : Float.parseFloat(strings[1]);
            if (strings.length >= 3 && (strings[2].contains("x") || strings[2].contains("X"))) {
                outOfLimits = true;
            }
            return new LogPointCLmdoc(calendar, temperature, outOfLimits);
        }
        return null;
    }
}

