/*
 * Decompiled with CFR 0.152.
 */
package com.zuehlke.qtag.parser.log;

import com.zuehlke.qtag.parser.log.LogFileParser;
import com.zuehlke.qtag.parser.log.MissingKeyException;
import com.zuehlke.qtag.parser.log.UnsupportedLogFileException;
import com.zuehlke.qtag.parser.log.model.ErrorQtagDevices;
import com.zuehlke.qtag.parser.log.model.ILogFileKey;
import com.zuehlke.qtag.parser.log.model.LogFileKey;
import com.zuehlke.qtag.parser.log.model.LogFileRawData;
import com.zuehlke.qtag.parser.log.model.QtagDevices;
import com.zuehlke.qtag.parser.log.model.fridgetag.AlarmConfiguration;
import com.zuehlke.qtag.parser.log.model.fridgetag.Configuration;
import com.zuehlke.qtag.parser.log.model.fridgetag.DailyAlarmStatistics;
import com.zuehlke.qtag.parser.log.model.fridgetag.DailySensorStatistics;
import com.zuehlke.qtag.parser.log.model.fridgetag.DailyStatistics;
import com.zuehlke.qtag.parser.log.model.fridgetag.DevicesFridgeTag;
import com.zuehlke.qtag.parser.log.model.fridgetag.EventFlags;
import com.zuehlke.qtag.parser.log.model.fridgetag.LogDataFridgeTag;
import com.zuehlke.qtag.parser.log.model.fridgetag.LogFileKeyFridgeTag;
import com.zuehlke.qtag.parser.log.model.fridgetag.LogFileVersionFridgeTag;
import com.zuehlke.qtag.parser.log.model.fridgetag.LogPointFridgeTag;
import com.zuehlke.qtag.util.CalendarUtils;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.TimeZone;
import org.jetbrains.annotations.NotNull;

public class LogFileParserFridgeTag
extends LogFileParser {
    private static final String DEFAULT_FILE_RESSOURCE = "DefaultValuesFridgeTag.txt";
    private static final int MAX_HIST_LENGTH = 120;
    protected LogDataFridgeTag logData = new LogDataFridgeTag();
    private static final Set<ILogFileKey> obligatoryKeys = new HashSet<ILogFileKey>(Arrays.asList(LogFileKey.DEVICE, LogFileKey.SERIAL, LogFileKeyFridgeTag.TIMEZONE));

    public LogFileParserFridgeTag(LogFileRawData logFileRawData) {
        super(logFileRawData);
        this.loadDefaultValues(DEFAULT_FILE_RESSOURCE);
    }

    @Override
    public LogDataFridgeTag parse() throws MissingKeyException, UnsupportedLogFileException {
        Set<ILogFileKey> missingKeys = this.getMissingKeys(obligatoryKeys);
        this.logData = new LogDataFridgeTag(super.parse());
        if (!missingKeys.isEmpty()) {
            throw new MissingKeyException(missingKeys);
        }
        this.parseLogFile();
        return this.logData;
    }

    private void parseLogFile() throws UnsupportedLogFileException {
        DevicesFridgeTag device = DevicesFridgeTag.getDeviceFromString(this.getValueFromKey(LogFileKey.DEVICE));
        LogFileVersionFridgeTag version = LogFileVersionFridgeTag.fromString(this.getValueFromKey(LogFileKeyFridgeTag.VERSION));
        if (!this.deviceSupported(device)) {
            throw new UnsupportedLogFileException("Unsupported Device.");
        }
        if (!version.isSupported()) {
            throw new UnsupportedLogFileException("Unsupported log file version: " + version.toString() + ".");
        }
        this.logData.setDevice(device);
        this.logData.setLogFileVersion(version);
        this.logData.setSensorNumber(this.parseInteger(LogFileKeyFridgeTag.SENSOR));
        this.logData.setSerialNumber(this.getValueFromKey(LogFileKey.SERIAL));
        this.parseConfiguration();
        this.parseHistory();
        this.parseDataSection();
        this.parseErrorSection();
    }

    @Override
    protected boolean deviceSupported(QtagDevices device) {
        boolean deviceSupported = false;
        if (EnumSet.of(QtagDevices.FT2).contains((Object)device)) {
            deviceSupported = true;
        }
        if (EnumSet.of(QtagDevices.FTULT).contains((Object)device)) {
            deviceSupported = true;
        }
        if (EnumSet.of(QtagDevices.FT3).contains((Object)device)) {
            deviceSupported = true;
        }
        return deviceSupported;
    }

    private boolean deviceSupported(DevicesFridgeTag device) {
        EnumSet<DevicesFridgeTag> supportedDevices = EnumSet.complementOf(EnumSet.of(DevicesFridgeTag.UNSPECIFIED));
        return supportedDevices.contains((Object)device);
    }

    private void parseConfiguration() {
        Configuration config = this.logData.getConfiguration();
        config.setConfigurationId(this.getValueFromKey(LogFileKeyFridgeTag.CID));
        config.setLotId(this.getValueFromKey(LogFileKeyFridgeTag.LOT));
        config.setTimeZone(this.parseTimezone(LogFileKeyFridgeTag.TIMEZONE));
        config.setMeasurementDelay(this.parseInteger(LogFileKeyFridgeTag.MEASUREMENT_DELAY));
        config.setMovingAverageIntervall(this.parseInteger(LogFileKeyFridgeTag.MOVING_AVERAGE));
        config.setUserAlarmConfigurationEnabled(this.parseBoolean(LogFileKeyFridgeTag.USER_ALARM_CONFIG_ENABLED));
        config.setTemperatureOffsetInternalSensor(this.parseFloat(LogFileKeyFridgeTag.TEMPERATURE_SENSOR_OFFSET_INT));
        config.setTemperatureOffsetExternalSensor(this.parseFloat(LogFileKeyFridgeTag.TEMPERATURE_SENSOR_OFFSET_EXT));
        config.setTimeoutInternalSensor(this.parseInteger(LogFileKeyFridgeTag.TEMPERATURE_SENSOR_TIMEOUT_INT));
        config.setTimeoutExternalSensor(this.parseInteger(LogFileKeyFridgeTag.TEMPERATURE_SENSOR_TIMEOUT_EXT));
        try {
            config.setUserClockChangeAllowed(this.parseBoolean(LogFileKeyFridgeTag.USER_CLOCK_CHANGE_ALLOWED));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            config.setUserClockChangeAllowed(true);
        }
        this.parseAlarmConfiguration();
    }

    private void parseAlarmConfiguration() {
        int upperAlarmDuration;
        AlarmConfiguration alarmConfig = this.logData.getConfiguration().getAlarmConfiguration();
        int lowerAlarmDuration = this.parseInteger(LogFileKeyFridgeTag.ALARM_LOWER_TIME_THRESHOLD);
        if (lowerAlarmDuration > 0) {
            float lowerAlarmThreshold = this.parseFloat(LogFileKeyFridgeTag.ALARM_LOWER_TEMPERATURE_THRESHOLD);
            alarmConfig.setLowerAlarmEnabled(lowerAlarmThreshold, lowerAlarmDuration);
        }
        if ((upperAlarmDuration = this.parseInteger(LogFileKeyFridgeTag.ALARM_UPPER_TIME_THRESHOLD)) > 0) {
            float upperAlarmThreshold = this.parseFloat(LogFileKeyFridgeTag.ALARM_UPPER_TEMPERATURE_THRESHOLD);
            alarmConfig.setUpperAlarmEnabled(upperAlarmThreshold, upperAlarmDuration);
        }
    }

    private void parseHistory() {
        String dateString;
        this.logData.getHistory().setTimestampActivation(this.parseCalendar(this.getValueFromKey(LogFileKeyFridgeTag.TIMESTAMP_ACTIVATION)));
        this.logData.getHistory().setTimestampReportCreation(this.parseCalendar(this.getValueFromKey(LogFileKeyFridgeTag.TIMESTAMP_REPORT_CREATION)));
        for (int i = 1; i <= 120 && (dateString = this.getValueFromKeyWithParam(LogFileKeyFridgeTag.HISTORY_DATE, 0, i)) != null; ++i) {
            LocalDate date = this.parseLocalDate(dateString);
            if (date == null) continue;
            this.parseSingleDayInHistory(date, i);
        }
    }

    private void parseSingleDayInHistory(LocalDate date, int dayIndex) {
        DailyStatistics dailyStats = new DailyStatistics();
        dailyStats.setDate(date);
        this.parseTempStatsOfSingleDay(dailyStats, dayIndex);
        this.parseAlarmStatsOfSingleDay(dailyStats, dayIndex);
        this.parseSensorTimeoutStatsOfSingleDay(dailyStats, dayIndex);
        this.parseHistoryChecked(dailyStats, dayIndex);
        this.parseEventFlags(dailyStats, dayIndex);
        this.logData.getHistory().addDailyStatistics(dailyStats);
    }

    private void parseEventFlags(DailyStatistics dailyStats, int dayIndex) {
        String str = this.getValueFromKeyWithParam(LogFileKeyFridgeTag.EVENTS, 0, dayIndex);
        if (str != null) {
            int eventFlagsValue = this.parseInteger(str);
            EventFlags eventFlags = new EventFlags(eventFlagsValue);
            dailyStats.setEventFlags(eventFlags);
        }
    }

    private void parseTempStatsOfSingleDay(@NotNull DailyStatistics dailyStats, int dayIndex) {
        String str = this.getValueFromKeyWithParam(LogFileKeyFridgeTag.TEMPERATURE_MINIMUM, 0, dayIndex);
        dailyStats.setMinTemperature(this.parseFloat(str));
        str = this.getValueFromKeyWithParam(LogFileKeyFridgeTag.TIME_TEMPERATURE_MINIMUM, 0, dayIndex);
        dailyStats.setMinTemperatureTimestamp(this.parseLocalTime(str));
        str = this.getValueFromKeyWithParam(LogFileKeyFridgeTag.TEMPERATURE_MAXIMUM, 0, dayIndex);
        dailyStats.setMaxTemperature(this.parseFloat(str));
        str = this.getValueFromKeyWithParam(LogFileKeyFridgeTag.TIME_TEMPERATURE_MAXIMUM, 0, dayIndex);
        dailyStats.setMaxTemperatureTimestamp(this.parseLocalTime(str));
        str = this.getValueFromKeyWithParam(LogFileKeyFridgeTag.TEMPERATURE_AVERAGE, 0, dayIndex);
        dailyStats.setAverageTemperature(this.parseFloat(str));
    }

    private void parseAlarmStatsOfSingleDay(@NotNull DailyStatistics dailyStats, int dayIndex) {
        dailyStats.setLowerAlarmStats(this.parseLowerAlarmStatsOfSingleDay(dayIndex));
        dailyStats.setUpperAlarmStats(this.parseUpperAlarmStatsOfSingleDay(dayIndex));
    }

    private void parseSensorTimeoutStatsOfSingleDay(@NotNull DailyStatistics dailyStats, int dayIndex) {
        dailyStats.setExternalSensorStats(this.parseExtSensorStatsOfSingleDay(dayIndex));
        dailyStats.setInternalSensorStats(this.parseIntSensorStatsOfSingleDay(dayIndex));
    }

    private void parseHistoryChecked(DailyStatistics dailyStats, int dayIndex) {
        String str = this.getValueFromKeyWithParam(LogFileKeyFridgeTag.TIME_HIST_CHECKED_AM, 0, dayIndex);
        if (str != null) {
            dailyStats.setHistoryCheckedAm(this.parseLocalTime(str));
        }
        if ((str = this.getValueFromKeyWithParam(LogFileKeyFridgeTag.TIME_HIST_CHECKED_PM, 0, dayIndex)) != null) {
            dailyStats.setHistoryCheckedPm(this.parseLocalTime(str));
        }
    }

    @NotNull
    private DailyAlarmStatistics parseLowerAlarmStatsOfSingleDay(int dayIndex) {
        DailyAlarmStatistics alarmStats = new DailyAlarmStatistics();
        String str = this.getValueFromKeyWithParam(LogFileKeyFridgeTag.ALARM_DURATION_LOWER, 0, dayIndex);
        if (str != null) {
            alarmStats.setAccumulatedAlarmDuration(this.parseInteger(str));
        }
        if ((str = this.getValueFromKeyWithParam(LogFileKeyFridgeTag.TIME_ALARM_LOWER, 0, dayIndex)) != null) {
            alarmStats.setAlarmTimestamp(this.parseLocalTime(str));
            str = this.getValueFromKeyWithParam(LogFileKeyFridgeTag.TEMPERATURE_AMBIENT_ALARM_LOWER, 0, dayIndex);
            alarmStats.setAmbientTemperature(this.parseFloat(str));
            str = this.getValueFromKeyWithParam(LogFileKeyFridgeTag.CONFIRMED_ALARM_LOWER, 0, dayIndex);
            if (str != null) {
                alarmStats.setAlarmConfiremd(this.parseBoolean(str));
            }
        }
        return alarmStats;
    }

    @NotNull
    private DailyAlarmStatistics parseUpperAlarmStatsOfSingleDay(int dayIndex) {
        DailyAlarmStatistics alarmStats = new DailyAlarmStatistics();
        String str = this.getValueFromKeyWithParam(LogFileKeyFridgeTag.ALARM_DURATION_UPPER, 0, dayIndex);
        if (str != null) {
            alarmStats.setAccumulatedAlarmDuration(this.parseInteger(str));
        }
        if ((str = this.getValueFromKeyWithParam(LogFileKeyFridgeTag.TIME_ALARM_UPPER, 0, dayIndex)) != null) {
            alarmStats.setAlarmTimestamp(this.parseLocalTime(str));
            str = this.getValueFromKeyWithParam(LogFileKeyFridgeTag.TEMPERATURE_AMBIENT_ALARM_UPPER, 0, dayIndex);
            alarmStats.setAmbientTemperature(this.parseFloat(str));
            str = this.getValueFromKeyWithParam(LogFileKeyFridgeTag.CONFIRMED_ALARM_UPPER, 0, dayIndex);
            if (str != null) {
                alarmStats.setAlarmConfiremd(this.parseBoolean(str));
            }
        }
        return alarmStats;
    }

    @NotNull
    private DailySensorStatistics parseExtSensorStatsOfSingleDay(int dayIndex) {
        DailySensorStatistics sensorStats = new DailySensorStatistics();
        String str = this.getValueFromKeyWithParam(LogFileKeyFridgeTag.TIMEOUT_DURATION_EXT_SENSOR, 0, dayIndex);
        if (str != null) {
            sensorStats.setAccumulatedTimeoutTime(this.parseInteger(str));
        }
        if ((str = this.getValueFromKeyWithParam(LogFileKeyFridgeTag.TIME_TIMEOUT_EXT_SENSOR, 0, dayIndex)) != null) {
            sensorStats.setTimeoutTime(this.parseLocalTime(str));
        }
        return sensorStats;
    }

    @NotNull
    private DailySensorStatistics parseIntSensorStatsOfSingleDay(int dayIndex) {
        DailySensorStatistics sensorStats = new DailySensorStatistics();
        String str = this.getValueFromKeyWithParam(LogFileKeyFridgeTag.TIMEOUT_DURATION_INT_SENSOR, 0, dayIndex);
        if (str != null) {
            sensorStats.setAccumulatedTimeoutTime(this.parseInteger(str));
        }
        if ((str = this.getValueFromKeyWithParam(LogFileKeyFridgeTag.TIME_TIMEOUT_INT_SENSOR, 0, dayIndex)) != null) {
            sensorStats.setTimeoutTime(this.parseLocalTime(str));
        }
        return sensorStats;
    }

    private void parseDataSection() {
        String[] header;
        ArrayList<String[]> logpoints = this.logFileRawData.getTabSeparatedData().get("Data");
        if (logpoints != null && (header = logpoints.get(0))[0].equals("yyyy-MM-dd hh:mm") && header[1].equals("T") && header[2].equals("Out of limits")) {
            logpoints.remove(0);
            for (String[] logpoint : logpoints) {
                LogPointFridgeTag logPoint2 = this.parseLogPoint(logpoint);
                if (logPoint2 == null) continue;
                this.logData.getLogPoints().add(logPoint2);
            }
        }
    }

    private Calendar parseCalendar(String value) {
        TimeZone timeZone = this.logData.getConfiguration().getTimeZone();
        if (timeZone == null) {
            throw new IllegalArgumentException("Timezone not initialized");
        }
        return this.parseCalendarFromTimestamp(value, timeZone);
    }

    private void parseErrorSection() {
        if (this.logFileRawData.containsErrors()) {
            for (int i = 0; i < 99; ++i) {
                String key = String.format("Errors.%d.Err Count", i);
                if (!this.logFileRawData.getKeyValueData().containsKey(key)) continue;
                int errorCount = this.parseInteger(this.getValueFromKeyWithParam(LogFileKeyFridgeTag.ERR_COUNT, 0, i));
                Calendar calendar = this.parseCalendar(this.getValueFromKeyWithParam(LogFileKeyFridgeTag.ERR_TIMESTAMP, 0, i));
                if (calendar == null) continue;
                this.logData.getErrors().add(new ErrorQtagDevices(i, errorCount, calendar));
            }
        }
    }

    protected LogPointFridgeTag parseLogPoint(@NotNull String[] strings) {
        boolean outOfLimits = false;
        if (strings.length >= 2) {
            LocalDateTime timestamp = CalendarUtils.parseAsLocalDateTime(strings[0]);
            float temperature = strings[1].equals("--.-") ? Float.NaN : Float.parseFloat(strings[1]);
            if (strings.length >= 3 && (strings[2].contains("x") || strings[2].contains("X"))) {
                outOfLimits = true;
            }
            return new LogPointFridgeTag(timestamp, temperature, outOfLimits);
        }
        return null;
    }
}

