/*
 * Decompiled with CFR 0.152.
 */
package com.zuehlke.qtag.parser.log;

import com.zuehlke.qtag.parser.log.LogFileParser;
import com.zuehlke.qtag.parser.log.LogFileParserCLmdoc;
import com.zuehlke.qtag.parser.log.LogFileParserFridgeTag;
import com.zuehlke.qtag.parser.log.MissingKeyException;
import com.zuehlke.qtag.parser.log.model.LogFileKey;
import com.zuehlke.qtag.parser.log.model.LogFileRawData;
import com.zuehlke.qtag.parser.log.model.QtagDevices;
import com.zuehlke.qtag.parser.log.model.clmdoc.LogFileKeyCLmdoc;
import java.util.ArrayList;

public class LogFilePreParser {
    private static final String ERROR_SECTION_1 = "Error";
    private static final String ERROR_SECTION_2 = "Errors";
    private static final String RESULT_SECTION = "Res";

    public static QtagDevices getDevice(LogFileRawData logFileRawData) throws MissingKeyException {
        if (logFileRawData == null) {
            throw new IllegalArgumentException("logFileRawData can not be null.");
        }
        if (!logFileRawData.getKeyValueData().containsKey(LogFileKey.DEVICE.toString())) {
            System.err.println("Device Key missing.");
            throw new MissingKeyException(LogFileKey.DEVICE);
        }
        ArrayList<String> arrayList = logFileRawData.getKeyValueData().get(LogFileKey.DEVICE.toString());
        String device = "";
        if (arrayList != null) {
            device = arrayList.get(0);
        }
        return QtagDevices.getDeviceFromString(device);
    }

    public static float getFileVersion(LogFileRawData logFileRawData) throws MissingKeyException {
        if (logFileRawData == null) {
            throw new IllegalArgumentException("logFileRawData can not be null.");
        }
        if (!logFileRawData.getKeyValueData().containsKey(LogFileKey.FILE_VERSION.toString())) {
            System.err.println("Version Key missing.");
            throw new MissingKeyException(LogFileKey.FILE_VERSION);
        }
        ArrayList<String> arrayList = logFileRawData.getKeyValueData().get(LogFileKey.FILE_VERSION.toString());
        String versionStr = "";
        if (arrayList != null) {
            versionStr = arrayList.get(0);
        }
        return Float.parseFloat(versionStr);
    }

    private static LogFileParser getLogFileParserForDeviceAndLogFileVersion(LogFileRawData logFileRawData, QtagDevices device, Float version) {
        switch (device) {
            case CLmdoc: {
                if (version.floatValue() >= 1.3f) {
                    return new LogFileParserCLmdoc(logFileRawData);
                }
                return new LogFileParser(logFileRawData);
            }
            case FT2: 
            case FTULT: 
            case FT3: {
                if (version.floatValue() >= 0.4f) {
                    return new LogFileParserFridgeTag(logFileRawData);
                }
                return new LogFileParser(logFileRawData);
            }
            case None: {
                throw new IllegalArgumentException("No device specified.");
            }
        }
        throw new IllegalArgumentException("Unsupported Device: " + device.toString());
    }

    public static LogFileParser getLogFileParser(LogFileRawData logFileRawData) throws MissingKeyException {
        if (logFileRawData == null) {
            throw new IllegalArgumentException("logFileRawData can not be null.");
        }
        QtagDevices device = LogFilePreParser.getDevice(logFileRawData);
        Float version = Float.valueOf(LogFilePreParser.getFileVersion(logFileRawData));
        return LogFilePreParser.getLogFileParserForDeviceAndLogFileVersion(logFileRawData, device, version);
    }

    public static boolean isErrorLogFile(LogFileRawData logFileRawData) {
        boolean isErrorLogFile = false;
        isErrorLogFile |= logFileRawData.getSectionNames().contains(ERROR_SECTION_1);
        return isErrorLogFile |= logFileRawData.getSectionNames().contains(ERROR_SECTION_2);
    }

    public static boolean isEncryptedLogFile(LogFileRawData logFileRawData) {
        return logFileRawData.getKeyValueData().containsKey(LogFileKeyCLmdoc.ENCRYPTED_DATA_LENGTH.toString());
    }

    public static boolean conaintsResultSection(LogFileRawData logFileRawData) {
        return logFileRawData.getSectionNames().contains(RESULT_SECTION);
    }
}

