/*
 * Decompiled with CFR 0.152.
 */
package com.zuehlke.qtag.parser.log;

import com.zuehlke.qtag.parser.log.model.LogFileRawData;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.Scanner;
import java.util.Stack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class LogFileReader {
    private static final String CHARSET_NAME = "ISO_8859_1";
    private static final String ENTRY_DELIMITER = ",";
    private static final String KEY_VALUE_DELIMITER = ": |:\\z";
    private static final String TAB_SEPARATED_DELIMITER = "\t";
    private LogFileRawData logFileRawData = new LogFileRawData();
    private boolean encryptedSectionActive;

    @NotNull
    @Contract(value="null -> fail")
    private static InputStream openReader(File file) throws FileNotFoundException {
        if (file == null) {
            throw new NullPointerException("File can not be null.");
        }
        return new FileInputStream(file);
    }

    public LogFileReader(File file) throws IOException {
        this(LogFileReader.openReader(file));
    }

    public LogFileReader(InputStream stream) throws IOException {
        InputStreamReader reader = new InputStreamReader(stream, CHARSET_NAME);
        ArrayList<LogFileLine> lines = this.readLinesFromLogFile(reader);
        this.extractDataFromLines(lines);
    }

    @NotNull
    private ArrayList<LogFileLine> readLinesFromLogFile(Reader reader) throws IOException {
        ArrayList<LogFileLine> lines = new ArrayList<LogFileLine>(100);
        try (BufferedReader bufferedReader = new BufferedReader(reader);){
            String line;
            this.encryptedSectionActive = false;
            while ((line = bufferedReader.readLine()) != null) {
                LogFileLine logFileLine = new LogFileLine();
                if (line.startsWith("Error")) {
                    this.logFileRawData.setContainsErrors(true);
                }
                if (this.isLineEncrypted(line)) continue;
                if (line.startsWith(TAB_SEPARATED_DELIMITER)) {
                    logFileLine.blockLevel = 1;
                    logFileLine.isTabSeparatedLine = true;
                } else {
                    logFileLine.blockLevel = LogFileReader.getNumberOfLeadingSpaces(line);
                }
                logFileLine.content = line.trim();
                lines.add(logFileLine);
            }
        }
        return lines;
    }

    private boolean isLineEncrypted(String line) {
        if (this.encryptedSectionActive) {
            if (line.contains("EncryptedDataLength")) {
                this.encryptedSectionActive = false;
            }
        } else if (line.contains("EncryptedData")) {
            this.encryptedSectionActive = true;
            return false;
        }
        return this.encryptedSectionActive;
    }

    public void extractDataFromLines(@NotNull ArrayList<LogFileLine> lines) {
        LogFileLine lastLine = new LogFileLine();
        GroupName groupName = new GroupName();
        for (LogFileLine l : lines) {
            int blockLevelDelta = l.blockLevel - lastLine.blockLevel;
            if (blockLevelDelta <= 0) {
                if (lastLine.isTabSeparatedLine) {
                    this.extractTabSeparatedDataFromLine(lastLine.content, groupName);
                } else {
                    this.extractKeyValuePairsFromLine(lastLine.content, groupName);
                }
            } else {
                groupName.push(lastLine.content);
                this.logFileRawData.addSectionName(groupName.toString(false));
            }
            if (blockLevelDelta < 0) {
                for (int i = blockLevelDelta; i < 0; ++i) {
                    groupName.pop();
                }
            }
            lastLine = l;
        }
        this.extractKeyValuePairsFromLine(lastLine.content, groupName);
    }

    private void extractKeyValuePairsFromLine(String line, GroupName groupName) {
        try (Scanner lineScanner = new Scanner(line);){
            lineScanner.useDelimiter(ENTRY_DELIMITER);
            while (lineScanner.hasNext()) {
                Map.Entry<String, String> keyValue = this.nextKeyValuePair(lineScanner.next());
                String fullKey = groupName.toString(true) + keyValue.getKey();
                this.logFileRawData.addKeyValuePair(fullKey, keyValue.getValue());
            }
        }
    }

    @NotNull
    @Contract(value="_ -> new")
    private Map.Entry<String, String> nextKeyValuePair(String keyValueString) {
        try (Scanner keyValueScanner = new Scanner(keyValueString).useDelimiter(KEY_VALUE_DELIMITER);){
            String key = keyValueScanner.next().trim();
            String value = null;
            if (keyValueScanner.hasNext()) {
                value = keyValueScanner.next().trim();
            }
            AbstractMap.SimpleEntry<String, String> simpleEntry = new AbstractMap.SimpleEntry<String, String>(key, value);
            return simpleEntry;
        }
    }

    private void extractTabSeparatedDataFromLine(@NotNull String line, @NotNull GroupName groupName) {
        String name = groupName.toString(false);
        String[] tabSeparatedString = line.split(TAB_SEPARATED_DELIMITER);
        this.logFileRawData.addTabSeparatedValue(name, tabSeparatedString);
    }

    public static int getNumberOfLeadingSpaces(@NotNull String line) {
        int oldLen = line.length();
        return oldLen - line.replaceFirst("^ {0,6}", "").length();
    }

    public LogFileRawData getLogFileRawData() {
        return this.logFileRawData;
    }

    private static class GroupName
    extends Stack<String> {
        private static final long serialVersionUID = 2687190790848354463L;

        private GroupName() {
        }

        @Override
        public String toString() {
            return this.toString(true);
        }

        public String toString(boolean trailingDot) {
            StringBuilder strBuilder = new StringBuilder();
            for (String obj : this) {
                strBuilder.append(obj).append(".");
            }
            int len = strBuilder.length();
            if (len > 0 && !trailingDot) {
                strBuilder.deleteCharAt(len - 1);
            }
            return strBuilder.toString();
        }

        @Override
        public String push(String item) {
            item = item.replace(":", "").trim();
            return super.push(item);
        }
    }

    private static class LogFileLine {
        private int blockLevel = 0;
        private String content = "";
        private boolean isTabSeparatedLine = false;

        public String toString() {
            return String.valueOf(this.blockLevel) + ": " + this.content;
        }
    }
}

