/*
 * Decompiled with CFR 0.152.
 */
package com.zuehlke.qtag.parser.log;

import com.zuehlke.qtag.parser.log.model.ILogFileKey;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class MissingKeyException
extends Exception {
    private static final long serialVersionUID = 5746854037252503069L;
    private Set<ILogFileKey> missingKeys;

    public MissingKeyException(Set<ILogFileKey> missingKeys) {
        super(MissingKeyException.createMessageString(missingKeys));
        this.missingKeys = missingKeys;
    }

    public MissingKeyException(ILogFileKey missingKey) {
        super(MissingKeyException.createMessageString(missingKey));
        HashSet<ILogFileKey> missingKeys = new HashSet<ILogFileKey>(1);
        missingKeys.add(missingKey);
        this.missingKeys = missingKeys;
    }

    @NotNull
    private static String createMessageString(@NotNull ILogFileKey missingKey) {
        return "Missing Key: " + missingKey.toString();
    }

    @NotNull
    private static String createMessageString(@NotNull Set<ILogFileKey> missingKeys) {
        String NEW_LINE = System.getProperty("line.separator");
        StringBuilder stringBuilder = new StringBuilder("Missing Keys:");
        stringBuilder.append(NEW_LINE);
        for (ILogFileKey key : missingKeys) {
            stringBuilder.append(key).append(NEW_LINE);
        }
        return stringBuilder.toString();
    }

    public Set<ILogFileKey> getMissingKeys() {
        return this.missingKeys;
    }
}

