/*
 * Decompiled with CFR 0.152.
 */
package com.zuehlke.qtag.parser.log.model;

import com.zuehlke.qtag.util.CalendarUtils;
import java.util.Calendar;
import java.util.TimeZone;

public class Certificate {
    private String version;
    private String lot;
    private String issuer;
    private Calendar validFromTimestamp;
    private String owner;
    private String publicKey;

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getLot() {
        return this.lot;
    }

    public void setLot(String lot) {
        this.lot = lot;
    }

    public Calendar getValidFromTimestamp() {
        return this.validFromTimestamp;
    }

    public void setValidFromTimestamp(Calendar validFromTimestamp) {
        this.validFromTimestamp = validFromTimestamp;
    }

    public void setValidFromTimestamp(String validFrom) {
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        this.validFromTimestamp = CalendarUtils.parseAsCalendar(validFrom, timeZone);
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String NEW_LINE = System.getProperty("line.separator");
        sb.append("  Vers: ").append(this.version).append(NEW_LINE);
        sb.append("  Lot: ").append(this.lot).append(NEW_LINE);
        sb.append("  Issuer: ").append(this.issuer).append(NEW_LINE);
        sb.append("  Valid from: ").append(this.validFromTimestamp != null ? CalendarUtils.formatISO(this.validFromTimestamp) : "").append(NEW_LINE);
        sb.append("  Owner: ").append(this.owner).append(NEW_LINE);
        sb.append("  Public Key: ").append(this.publicKey).append(NEW_LINE);
        return sb.toString();
    }
}

