/*
 * Decompiled with CFR 0.152.
 */
package com.zuehlke.qtag.parser.log.model.clmdoc;

import com.zuehlke.qtag.parser.log.model.clmdoc.IConfigurationFlags;
import com.zuehlke.qtag.parser.log.model.clmdoc.ILogDataCLmdoc;
import com.zuehlke.qtag.parser.log.model.clmdoc.alarm.AlarmConfiguration;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.TimeZone;

public class Configuration
implements ILogDataCLmdoc.IConfiguration {
    public static final int NR_OF_USER_STRINGS = 3;
    public static final int NR_OF_ALARMS = 5;
    private String configurationId;
    private String lotId;
    private TimeZone timeZone;
    private int startDelay;
    private int maxTransportDuration;
    private int movingAverageInterval;
    private float mktEnergy;
    private IConfigurationFlags configurationFlagInterface;
    private float toleranceAboveUpperLimit;
    private float toleranceBelowLowerLimit;
    private float toleranceWithinLimit;
    private float batteryWarningLimit;
    private float temperatureOffset;
    private String[] userString;
    private int testResult;
    private Calendar testTimestamp;
    private ArrayList<AlarmConfiguration> alarmConfiguration = new ArrayList(5);
    private int logInterval;

    public Configuration() {
        this.userString = new String[3];
    }

    @Override
    public String getConfigurationId() {
        return this.configurationId;
    }

    @Override
    public String getLotId() {
        return this.lotId;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @Override
    public int getStartDelay() {
        return this.startDelay;
    }

    @Override
    public int getMaxTransportDuration() {
        return this.maxTransportDuration;
    }

    @Override
    public int getMovingAverageInterval() {
        return this.movingAverageInterval;
    }

    @Override
    public float getMktEnergy() {
        return this.mktEnergy;
    }

    @Override
    public float getToleranceAboveUpperLimit() {
        return this.toleranceAboveUpperLimit;
    }

    @Override
    public float getToleranceBelowLowerLimit() {
        return this.toleranceBelowLowerLimit;
    }

    @Override
    public float getBatteryWarningLimit() {
        return this.batteryWarningLimit;
    }

    @Override
    public float getTemperatureOffset() {
        return this.temperatureOffset;
    }

    @Override
    public String[] getUserString() {
        return this.userString;
    }

    @Override
    public ArrayList<AlarmConfiguration> getAlarmConfiguration() {
        return this.alarmConfiguration;
    }

    public int getTestResult() {
        return this.testResult;
    }

    public void setTestResult(int testResult) {
        this.testResult = testResult;
    }

    public Calendar getTestTimestamp() {
        return this.testTimestamp;
    }

    public void setTestTimestamp(Calendar testTimestamp) {
        this.testTimestamp = testTimestamp;
    }

    public void setConfigurationId(String configurationId) {
        this.configurationId = configurationId;
    }

    public void setLotId(String lotId) {
        this.lotId = lotId;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public void setStartDelay(int startDelay) {
        this.startDelay = startDelay;
    }

    public void setMaxTransportDuration(int maxTransportDuration) {
        this.maxTransportDuration = maxTransportDuration;
    }

    public void setMovingAverageInterval(int movingAverageInterval) {
        this.movingAverageInterval = movingAverageInterval;
    }

    public void setMktEnergy(float mktEnergy) {
        this.mktEnergy = mktEnergy;
    }

    public void setToleranceAboveUpperLimit(float toleranceAboveUpperLimit) {
        this.toleranceAboveUpperLimit = toleranceAboveUpperLimit;
    }

    public void setToleranceBelowLowerLimit(float toleranceBelowLowerLimit) {
        this.toleranceBelowLowerLimit = toleranceBelowLowerLimit;
    }

    public void setBatteryWarningLimit(float batteryWarningLimit) {
        this.batteryWarningLimit = batteryWarningLimit;
    }

    public void setTemperatureOffset(float temperatureOffset) {
        this.temperatureOffset = temperatureOffset;
    }

    public void setUserString(String[] userString) {
        this.userString = userString;
    }

    public void setAlarmConfiguration(ArrayList<AlarmConfiguration> alarmConfiguration) {
        this.alarmConfiguration = alarmConfiguration;
    }

    public IConfigurationFlags getConfigurationFlags() {
        return this.configurationFlagInterface;
    }

    public void setConfigurationFlags(IConfigurationFlags configurationFlagInterface) {
        this.configurationFlagInterface = configurationFlagInterface;
    }

    public float getToleranceWithinLimit() {
        return this.toleranceWithinLimit;
    }

    public void setToleranceWithinLimit(float toleranceWithinLimit) {
        this.toleranceWithinLimit = toleranceWithinLimit;
    }

    public int getLogInterval() {
        return this.logInterval;
    }

    public void setLogInterval(int logInterval) {
        this.logInterval = logInterval;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String NEW_LINE = System.getProperty("line.separator");
        sb.append(" CID: ").append(this.configurationId).append(NEW_LINE);
        sb.append(" Lot ID: ").append(this.lotId).append(NEW_LINE);
        sb.append(" Timezone: ").append(this.timeZone).append(NEW_LINE);
        sb.append(" Start Delay: ").append(this.startDelay).append(NEW_LINE);
        sb.append(" Max. Transport Duration: ").append(this.maxTransportDuration).append(NEW_LINE);
        sb.append(" Moving average interval: ").append(this.movingAverageInterval).append(NEW_LINE);
        sb.append(" MKT energy: ").append(this.mktEnergy).append(NEW_LINE);
        sb.append(" Tol. above upper limit: ").append(this.toleranceAboveUpperLimit).append(" \u00b0C").append(NEW_LINE);
        sb.append(" Tol. below lower limit: ").append(this.toleranceBelowLowerLimit).append(" \u00b0C").append(NEW_LINE);
        sb.append(" Tol. within limit: ").append(this.toleranceWithinLimit).append(" \u00b0C").append(NEW_LINE);
        sb.append(" Battery warning limit: ").append(this.batteryWarningLimit).append(" V").append(NEW_LINE);
        sb.append(" Temp. offset: ").append(this.temperatureOffset).append(" \u00b0C").append(NEW_LINE);
        for (String uString : this.userString) {
            sb.append(" User String: ").append(uString).append(NEW_LINE);
        }
        sb.append(" Test Result: ").append(this.testResult).append(", TS: ").append(this.testTimestamp).append(NEW_LINE);
        sb.append(" Alarm configuration: ").append(NEW_LINE);
        for (AlarmConfiguration aConfig : this.alarmConfiguration) {
            sb.append(aConfig).append(NEW_LINE);
        }
        return sb.toString();
    }
}

