/*
 * Decompiled with CFR 0.152.
 */
package com.zuehlke.qtag.parser.log.model.clmdoc;

import com.zuehlke.qtag.parser.log.model.ErrorQtagDevices;
import com.zuehlke.qtag.parser.log.model.LogData;
import com.zuehlke.qtag.parser.log.model.clmdoc.Configuration;
import com.zuehlke.qtag.parser.log.model.clmdoc.DevicesCLmdoc;
import com.zuehlke.qtag.parser.log.model.clmdoc.ILogDataCLmdoc;
import com.zuehlke.qtag.parser.log.model.clmdoc.LogFileVersionCLmdoc;
import com.zuehlke.qtag.parser.log.model.clmdoc.LogPointCLmdoc;
import com.zuehlke.qtag.parser.log.model.clmdoc.Marker;
import com.zuehlke.qtag.parser.log.model.clmdoc.Result;
import com.zuehlke.qtag.parser.log.model.clmdoc.TransportDurationStatus;
import java.util.ArrayList;

public class LogDataCLmdoc
extends LogData
implements ILogDataCLmdoc {
    public static final int NR_OF_ALARMS = 5;
    private DevicesCLmdoc device;
    private LogFileVersionCLmdoc logFileVersion;
    private int deviceId;
    private int sensorNumber;
    private Configuration configuration;
    private Result result;
    private ArrayList<Marker> markers;
    private ArrayList<LogPointCLmdoc> logPoints;
    private ArrayList<ErrorQtagDevices> errors;

    public LogDataCLmdoc(LogData logData) {
        this.setSerialNumber(logData.getSerialNumber());
        this.setSignature(logData.getSignature());
        this.setSignature(logData.getSignature());
        this.setFwVersion(logData.getFwVersion());
        this.setQtagDevice(logData.getQtagDevice());
        this.init();
    }

    public LogDataCLmdoc() {
        this.init();
    }

    private void init() {
        this.configuration = new Configuration();
        this.result = new Result();
        this.logPoints = new ArrayList(100);
        this.markers = new ArrayList(10);
        this.errors = new ArrayList(0);
    }

    @Override
    public DevicesCLmdoc getDevice() {
        return this.device;
    }

    @Override
    public int getDeviceId() {
        return this.deviceId;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public Result getResult() {
        return this.result;
    }

    public int getSensorNumber() {
        return this.sensorNumber;
    }

    public void setSensorNumber(int sensorNumber) {
        this.sensorNumber = sensorNumber;
    }

    public void setDevice(DevicesCLmdoc device) {
        this.device = device;
    }

    public void setDeviceId(int deviceId) {
        this.deviceId = deviceId;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setResult(Result result) {
        this.result = result;
    }

    public LogFileVersionCLmdoc getLogFileVersion() {
        return this.logFileVersion;
    }

    public void setLogFileVersion(LogFileVersionCLmdoc logFileVersion) {
        this.logFileVersion = logFileVersion;
    }

    public ArrayList<LogPointCLmdoc> getLogPoints() {
        return this.logPoints;
    }

    public ArrayList<Marker> getMarkers() {
        return this.markers;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        String NEW_LINE = System.getProperty("line.separator");
        sb.append("---- Log File Data ----").append(NEW_LINE);
        sb.append(" Log File version: ").append(this.logFileVersion.toString()).append(NEW_LINE);
        sb.append(" Device: ").append(this.device.toString()).append(". Device ID: ").append(this.deviceId).append(NEW_LINE);
        sb.append(" Sensor Number: ").append(this.sensorNumber).append(NEW_LINE);
        sb.append("->  Configuration: ").append("\n").append(this.configuration).append(NEW_LINE);
        sb.append("-> Result: ").append("\n").append(this.result).append(NEW_LINE);
        return sb.toString();
    }

    @Override
    public ArrayList<ErrorQtagDevices> getErrors() {
        return this.errors;
    }

    @Override
    public TransportDurationStatus getTransportDurationStatus() {
        if (this.configuration != null && this.configuration.getMaxTransportDuration() == 0) {
            return TransportDurationStatus.NOT_MONITORED;
        }
        if (this.configuration == null && this.result == null) {
            return null;
        }
        if (this.result.getTransportTimeInDays() <= this.configuration.getMaxTransportDuration()) {
            return TransportDurationStatus.OK;
        }
        return TransportDurationStatus.EXPIRED;
    }

    @Override
    public boolean isTemperatureAlarmOccurred() {
        boolean alarmOccurred = false;
        if (this.getResult() != null) {
            alarmOccurred = this.getResult().hasAlarms();
        }
        return alarmOccurred;
    }
}

