/*
 * Decompiled with CFR 0.152.
 */
package com.zuehlke.qtag.parser.log.model.clmdoc;

public enum LogFileVersionCLmdoc {
    UNKNOWN,
    OLDER,
    V1_0(1.0),
    V1_1(1.1),
    V1_2(1.2),
    V1_3(1.3),
    V1_4(1.4),
    V1_5(1.5),
    V1_6(1.6),
    V1_7(1.7),
    V1_8(1.8),
    V1_9(1.9),
    NEWER;

    private static final double minSupportedVersion = 1.3;
    private static final double maxSupportedVersion = 1.99;
    private double version;

    private LogFileVersionCLmdoc(double version) {
        this.version = version;
    }

    private LogFileVersionCLmdoc() {
        this.version = 0.0;
    }

    public String toString() {
        return Double.toString(this.version);
    }

    public double getVersion() {
        return this.version;
    }

    public void setVersion(double version) {
        this.version = version;
    }

    public static LogFileVersionCLmdoc fromString(String version) {
        LogFileVersionCLmdoc versionCLmdoc = UNKNOWN;
        try {
            double d = Double.parseDouble(version);
            for (LogFileVersionCLmdoc v : LogFileVersionCLmdoc.values()) {
                if (v.getVersion() != d) continue;
                return v;
            }
            if (d > V1_9.getVersion()) {
                versionCLmdoc = NEWER;
                versionCLmdoc.setVersion(d);
            } else if (d < V1_0.getVersion()) {
                versionCLmdoc = OLDER;
                versionCLmdoc.setVersion(d);
            }
            return versionCLmdoc;
        }
        catch (NumberFormatException e) {
            return UNKNOWN;
        }
    }

    public boolean isSameOrNewerLogFileVersion(LogFileVersionCLmdoc logFileVersion) {
        return this.ordinal() >= logFileVersion.ordinal();
    }

    public boolean isSupported() {
        return this.version >= 1.3 && this.version <= 1.99;
    }
}

