/*
 * Decompiled with CFR 0.152.
 */
package com.zuehlke.qtag.parser.log.model.clmdoc;

import com.zuehlke.qtag.parser.log.model.clmdoc.alarm.Alarm;
import com.zuehlke.qtag.parser.log.model.clmdoc.alarm.AlarmType;
import com.zuehlke.qtag.util.CalendarUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class Result {
    private Calendar timestampActivated;
    private Calendar timestampStarted;
    private Calendar timestampStopped;
    private int transportTimeInDays;
    private Calendar timestampBattTemp;
    private Calendar timestampBattCrit;
    private float minT;
    private Calendar tsMinT;
    private float maxT;
    private Calendar tsMaxT;
    private float mkt;
    private float avrgT;
    private List<Alarm> alarms = new ArrayList<Alarm>();

    public Calendar getTimestampActivated() {
        return this.timestampActivated;
    }

    public void setTimestampActivated(Calendar timestampActivated) {
        this.timestampActivated = timestampActivated;
    }

    public Calendar getTimestampStarted() {
        return this.timestampStarted;
    }

    public void setTimestampStarted(Calendar timestampStarted) {
        this.timestampStarted = timestampStarted;
    }

    public Calendar getTimestampStopped() {
        return this.timestampStopped;
    }

    public void setTimestampStopped(Calendar timestampStopped) {
        this.timestampStopped = timestampStopped;
    }

    public int getTransportTimeInDays() {
        return this.transportTimeInDays;
    }

    public void setTransportTimeInDays(int transportTime) {
        this.transportTimeInDays = transportTime;
    }

    public Calendar getTsBattTemp() {
        return this.timestampBattTemp;
    }

    public void setTimestampBattTemp(Calendar tsBattTemp) {
        this.timestampBattTemp = tsBattTemp;
    }

    public Calendar getTimestampBattCrit() {
        return this.timestampBattCrit;
    }

    public void setTimestampBattCrit(Calendar tsBattCrit) {
        this.timestampBattCrit = tsBattCrit;
    }

    public float getMinT() {
        return this.minT;
    }

    public void setMinT(float minT) {
        this.minT = minT;
    }

    public Calendar getTsMinT() {
        return this.tsMinT;
    }

    public void setTsMinT(Calendar tsMinT) {
        this.tsMinT = tsMinT;
    }

    public float getMaxT() {
        return this.maxT;
    }

    public void setMaxT(float maxT) {
        this.maxT = maxT;
    }

    public Calendar getTsMaxT() {
        return this.tsMaxT;
    }

    public void setTsMaxT(Calendar tsMaxT) {
        this.tsMaxT = tsMaxT;
    }

    public float getMkt() {
        return this.mkt;
    }

    public void setMkt(float mkt) {
        this.mkt = mkt;
    }

    public float getAvrgT() {
        return this.avrgT;
    }

    public void setAvrgT(float avrgT) {
        this.avrgT = avrgT;
    }

    public List<Alarm> getAlarms() {
        return this.alarms;
    }

    public List<Alarm> getAlarmsByIndex(int index, boolean includeStartedOnlyCumulativeAlarms) {
        ArrayList<Alarm> alarmsFiltered = new ArrayList<Alarm>(3);
        for (Alarm alarm : this.alarms) {
            if (alarm.getIndex() != index) continue;
            if (alarm.hasAlarm()) {
                alarmsFiltered.add(alarm);
                continue;
            }
            if (!includeStartedOnlyCumulativeAlarms || !alarm.getType().equals((Object)AlarmType.ACCUMULATED_ABOVE) && !alarm.getType().equals((Object)AlarmType.ACCUMULATED_BELOW)) continue;
            alarmsFiltered.add(alarm);
        }
        return alarmsFiltered;
    }

    public void addAlarm(Alarm alarm) {
        if (alarm == null) {
            throw new IllegalArgumentException("Alarm can not be null");
        }
        this.alarms.add(alarm);
    }

    public boolean hasAlarms() {
        for (Alarm alarm : this.alarms) {
            if (!alarm.hasAlarm()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(" TS Actv: ").append(this.timestampActivated != null ? CalendarUtils.formatISO(this.timestampActivated) : "").append("\n");
        sb.append(" TS Stop: ").append(this.timestampStopped != null ? CalendarUtils.formatISO(this.timestampStopped) : "").append("\n");
        sb.append(" Transport: ").append(this.transportTimeInDays).append("\n");
        sb.append(" TS Batt Temp: ").append(this.timestampBattTemp != null ? CalendarUtils.formatISO(this.timestampBattTemp) : "").append("\n");
        sb.append(" TS Batt Crit: ").append(this.timestampBattCrit != null ? CalendarUtils.formatISO(this.timestampBattCrit) : "").append("\n");
        sb.append(" Min T: ").append(this.minT).append(", TS Min T: ").append(this.tsMinT != null ? CalendarUtils.formatISO(this.tsMinT) : "").append("\n");
        sb.append(" Max T: ").append(this.maxT).append(", TS Max T: ").append(this.tsMaxT != null ? CalendarUtils.formatISO(this.tsMaxT) : "").append("\n");
        sb.append(" MKT: ").append(this.mkt).append("\n");
        sb.append(" Avrg T: ").append(this.avrgT).append("\n");
        if (this.alarms != null) {
            sb.append(" Alarm:\n");
            for (Alarm alarm : this.alarms) {
                if (alarm == null) continue;
                sb.append("  ").append(alarm.getIndex()).append(":\n");
                sb.append("   ").append(alarm).append("\n");
            }
            sb.replace(sb.length() - 1, sb.length(), "");
        }
        return sb.toString();
    }
}

