/*
 * Decompiled with CFR 0.152.
 */
package com.zuehlke.qtag.parser.log.model.clmdoc.alarm;

import com.zuehlke.qtag.parser.log.model.clmdoc.alarm.AlarmType;

public class AlarmConfiguration {
    private AlarmType type = AlarmType.NONE;
    private float tempThreshold;
    private int timeThreshold;
    private float tempThresholdTTE;
    private float thresholdTTE;
    private int alarmNumber;

    public AlarmConfiguration(int alarmNr) {
        this.alarmNumber = alarmNr;
    }

    public float getTempThreshold() {
        return this.tempThreshold;
    }

    public void setTempThreshold(float tempThreshold) {
        this.tempThreshold = tempThreshold;
    }

    public int getTimeThresholdInMinutes() {
        return this.timeThreshold;
    }

    public void setTimeThreshold(int timeThreshold) {
        this.timeThreshold = timeThreshold;
    }

    public AlarmType getType() {
        return this.type;
    }

    public void setType(AlarmType type) {
        this.type = type;
    }

    public float getTempThresholdTTE() {
        return this.tempThresholdTTE;
    }

    public void setTempThresholdTTE(float tempThresholdTTE) {
        this.tempThresholdTTE = tempThresholdTTE;
    }

    public float getThresholdTTE() {
        return this.thresholdTTE;
    }

    public void setThresholdTTE(float thresholdTTE) {
        this.thresholdTTE = thresholdTTE;
    }

    public int getAlarmNumber() {
        return this.alarmNumber;
    }

    public void setAlarmNumber(int alarmNumber) {
        this.alarmNumber = alarmNumber;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("   Type: ").append((Object)this.type);
        switch (this.type) {
            case NONE: {
                break;
            }
            case SINGLE_BELOW: 
            case SINGLE_ABOVE: 
            case ACCUMULATED_BELOW: 
            case ACCUMULATED_ABOVE: {
                sb.append(", T AL: ").append(this.tempThreshold).append(", t AL: ").append(this.timeThreshold);
                break;
            }
            case TTE: {
                sb.append(", T EL: ").append(this.tempThresholdTTE).append(", E AL: ").append(this.thresholdTTE);
            }
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AlarmConfiguration)) {
            return false;
        }
        AlarmConfiguration that = (AlarmConfiguration)o;
        if (Float.compare(that.tempThreshold, this.tempThreshold) != 0) {
            return false;
        }
        if (Float.compare(that.tempThresholdTTE, this.tempThresholdTTE) != 0) {
            return false;
        }
        if (Float.compare(that.thresholdTTE, this.thresholdTTE) != 0) {
            return false;
        }
        if (this.timeThreshold != that.timeThreshold) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + (this.tempThreshold != 0.0f ? Float.floatToIntBits(this.tempThreshold) : 0);
        result = 31 * result + this.timeThreshold;
        result = 31 * result + (this.tempThresholdTTE != 0.0f ? Float.floatToIntBits(this.tempThresholdTTE) : 0);
        result = 31 * result + (this.thresholdTTE != 0.0f ? Float.floatToIntBits(this.thresholdTTE) : 0);
        return result;
    }

    public static AlarmConfiguration parseFromString(String type, String tempThreshold, String timeThreshold, int alarmNr) {
        if (type == null || tempThreshold == null || timeThreshold == null) {
            throw new IllegalArgumentException("String can not be null.");
        }
        AlarmConfiguration alarmConfiguration = new AlarmConfiguration(alarmNr);
        AlarmType alarmType = AlarmType.getByIntKey(Integer.parseInt(type));
        alarmConfiguration.setType(alarmType);
        switch (alarmType) {
            case NONE: {
                break;
            }
            case SINGLE_BELOW: 
            case SINGLE_ABOVE: 
            case ACCUMULATED_BELOW: 
            case ACCUMULATED_ABOVE: {
                alarmConfiguration.setTempThreshold(Float.parseFloat(tempThreshold));
                alarmConfiguration.setTimeThreshold(Integer.parseInt(timeThreshold));
                break;
            }
            case TTE: {
                alarmConfiguration.setTempThresholdTTE(Float.parseFloat(tempThreshold));
                alarmConfiguration.setThresholdTTE(Integer.parseInt(timeThreshold));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknwon alarm type.");
            }
        }
        return alarmConfiguration;
    }
}

