/*
 * Decompiled with CFR 0.152.
 */
package com.zuehlke.qtag.parser.log.model.fridgetag;

import com.zuehlke.qtag.parser.log.model.ISensorAlarm;
import com.zuehlke.qtag.parser.log.model.ITemperatureAlarm;
import com.zuehlke.qtag.parser.log.model.fridgetag.DailyAlarmStatistics;
import com.zuehlke.qtag.parser.log.model.fridgetag.DailySensorStatistics;
import com.zuehlke.qtag.parser.log.model.fridgetag.IEventFlags;
import java.time.LocalDate;
import java.time.LocalTime;

public class DailyStatistics
implements ITemperatureAlarm,
ISensorAlarm {
    private LocalDate date;
    private float minTemperature;
    private float maxTemperature;
    private LocalTime minTemperatureTime;
    private LocalTime maxTemperatureTime;
    private float averageTemperature;
    private DailyAlarmStatistics lowerAlarmStats = new DailyAlarmStatistics();
    private DailyAlarmStatistics upperAlarmStats = new DailyAlarmStatistics();
    private DailySensorStatistics internalSensorStats = new DailySensorStatistics();
    private DailySensorStatistics externalSensorStats = new DailySensorStatistics();
    private LocalTime historyCheckedAm;
    private LocalTime historyCheckedPm;
    private IEventFlags eventFlags;

    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public float getMinTemperature() {
        return this.minTemperature;
    }

    public void setMinTemperature(float minTemperature) {
        this.minTemperature = minTemperature;
    }

    public float getMaxTemperature() {
        return this.maxTemperature;
    }

    public void setMaxTemperature(float maxTemperature) {
        this.maxTemperature = maxTemperature;
    }

    public LocalTime getMinTemperatureTime() {
        return this.minTemperatureTime;
    }

    public void setMinTemperatureTimestamp(LocalTime minTemperatureTime) {
        this.minTemperatureTime = minTemperatureTime;
    }

    public LocalTime getMaxTemperatureTime() {
        return this.maxTemperatureTime;
    }

    public void setMaxTemperatureTimestamp(LocalTime maxTemperatureTimestamp) {
        this.maxTemperatureTime = maxTemperatureTimestamp;
    }

    public float getAverageTemperature() {
        return this.averageTemperature;
    }

    public void setAverageTemperature(float averageTemperature) {
        this.averageTemperature = averageTemperature;
    }

    public DailyAlarmStatistics getLowerAlarmStats() {
        return this.lowerAlarmStats;
    }

    public void setLowerAlarmStats(DailyAlarmStatistics lowerAlarmStats) {
        this.lowerAlarmStats = lowerAlarmStats;
    }

    public DailyAlarmStatistics getUpperAlarmStats() {
        return this.upperAlarmStats;
    }

    public void setUpperAlarmStats(DailyAlarmStatistics upperAlarmStats) {
        this.upperAlarmStats = upperAlarmStats;
    }

    public DailySensorStatistics getInternalSensorStats() {
        return this.internalSensorStats;
    }

    public void setInternalSensorStats(DailySensorStatistics internalSensorStats) {
        this.internalSensorStats = internalSensorStats;
    }

    public DailySensorStatistics getExternalSensorStats() {
        return this.externalSensorStats;
    }

    public void setExternalSensorStats(DailySensorStatistics externalSensorStats) {
        this.externalSensorStats = externalSensorStats;
    }

    public LocalTime getHistoryCheckedAm() {
        return this.historyCheckedAm;
    }

    public void setHistoryCheckedAm(LocalTime historyCheckedAm) {
        this.historyCheckedAm = historyCheckedAm;
    }

    public LocalTime getHistoryCheckedPm() {
        return this.historyCheckedPm;
    }

    public void setHistoryCheckedPm(LocalTime historyCheckedPm) {
        this.historyCheckedPm = historyCheckedPm;
    }

    public IEventFlags getEventFlags() {
        return this.eventFlags;
    }

    public void setEventFlags(IEventFlags eventFlags) {
        this.eventFlags = eventFlags;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String NEW_LINE = System.getProperty("line.separator");
        sb.append("-- Daily statistics of ").append(this.date).append(" --").append(NEW_LINE);
        sb.append(" min. Temp: ").append(this.minTemperature).append(" @ ").append(this.minTemperatureTime).append(NEW_LINE);
        sb.append(" max. Temp: ").append(this.maxTemperature).append(" @ ").append(this.maxTemperatureTime).append(NEW_LINE);
        sb.append(" avg. Temp: ").append(this.averageTemperature).append(NEW_LINE);
        sb.append(" Lower alarm stats: ").append(this.lowerAlarmStats).append(NEW_LINE);
        sb.append(" Upper alarm stats: ").append(this.upperAlarmStats).append(NEW_LINE);
        sb.append(" Int. sensor stats: ").append(this.internalSensorStats).append(NEW_LINE);
        sb.append(" Ext. sensor stats: ").append(this.externalSensorStats).append(NEW_LINE);
        if (this.historyCheckedAm != null) {
            sb.append(" Checked AM:").append(this.historyCheckedAm).append(NEW_LINE);
        }
        if (this.historyCheckedPm != null) {
            sb.append(" Checked PM:").append(this.historyCheckedPm).append(NEW_LINE);
        }
        sb.append("Event flags: ").append(this.eventFlags).append(NEW_LINE);
        return sb.toString();
    }

    @Override
    public boolean isTemperatureAlarmOccurred() {
        boolean temperatureAlarmOccurred = false;
        if (this.lowerAlarmStats != null) {
            temperatureAlarmOccurred = this.lowerAlarmStats.isTemperatureAlarmOccurred();
        }
        if (this.upperAlarmStats != null) {
            temperatureAlarmOccurred |= this.upperAlarmStats.isTemperatureAlarmOccurred();
        }
        return temperatureAlarmOccurred;
    }

    @Override
    public boolean isSensorAlarmOccurred() {
        boolean sensorAlarmOccurred = false;
        if (this.lowerAlarmStats != null) {
            sensorAlarmOccurred = this.internalSensorStats.isTimeoutOccurred();
        }
        if (this.upperAlarmStats != null) {
            sensorAlarmOccurred |= this.externalSensorStats.isTimeoutOccurred();
        }
        return sensorAlarmOccurred;
    }
}

