/*
 * Decompiled with CFR 0.152.
 */
package com.zuehlke.qtag.parser.log.model.fridgetag;

import com.zuehlke.qtag.parser.log.model.ISensorAlarm;
import com.zuehlke.qtag.parser.log.model.ITemperatureAlarm;
import com.zuehlke.qtag.parser.log.model.fridgetag.DailyStatistics;
import com.zuehlke.qtag.parser.log.model.fridgetag.ILogDataFridgeTag;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class History
implements ILogDataFridgeTag.IHistory {
    private Calendar timestampActivation;
    private Calendar timestampReportCreation;
    private List<DailyStatistics> allDailyStatistics = new ArrayList<DailyStatistics>(112);

    @Override
    public Calendar getTimestampActivation() {
        return this.timestampActivation;
    }

    public void setTimestampActivation(Calendar timestampActivation) {
        this.timestampActivation = timestampActivation;
    }

    @Override
    public Calendar getTimestampReportCreation() {
        return this.timestampReportCreation;
    }

    @Override
    public List<DailyStatistics> getAllDailyStatistics() {
        return this.allDailyStatistics;
    }

    public void setTimestampReportCreation(Calendar timestampReportCreation) {
        this.timestampReportCreation = timestampReportCreation;
    }

    public void addDailyStatistics(DailyStatistics dailyStatistics) {
        if (dailyStatistics == null) {
            throw new IllegalArgumentException("Dailystatistics can not be null");
        }
        this.allDailyStatistics.add(dailyStatistics);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String NEW_LINE = System.getProperty("line.separator");
        sb.append("Result data: ").append(NEW_LINE);
        sb.append("Device activated: ").append(this.timestampActivation).append(NEW_LINE);
        sb.append("Report created: ").append(this.timestampReportCreation).append(NEW_LINE);
        sb.append("-- Statistics --").append(NEW_LINE);
        for (DailyStatistics dailyStats : this.allDailyStatistics) {
            sb.append(dailyStats).append(NEW_LINE);
        }
        return sb.toString();
    }

    @Override
    public boolean isTemperatureAlarmOccurred() {
        boolean anyAlarmOccurred = false;
        if (this.allDailyStatistics != null) {
            for (ITemperatureAlarm iTemperatureAlarm : this.allDailyStatistics) {
                anyAlarmOccurred |= iTemperatureAlarm.isTemperatureAlarmOccurred();
            }
        }
        return anyAlarmOccurred;
    }

    @Override
    public boolean isSensorAlarmOccurred() {
        boolean anyAlarmOccurred = false;
        if (this.allDailyStatistics != null) {
            for (ISensorAlarm iSensorAlarm : this.allDailyStatistics) {
                anyAlarmOccurred |= iSensorAlarm.isSensorAlarmOccurred();
            }
        }
        return anyAlarmOccurred;
    }
}

