/*
 * Decompiled with CFR 0.152.
 */
package com.zuehlke.qtag.parser.log.model.fridgetag;

import com.zuehlke.qtag.parser.log.model.ErrorQtagDevices;
import com.zuehlke.qtag.parser.log.model.LogData;
import com.zuehlke.qtag.parser.log.model.fridgetag.Configuration;
import com.zuehlke.qtag.parser.log.model.fridgetag.DevicesFridgeTag;
import com.zuehlke.qtag.parser.log.model.fridgetag.History;
import com.zuehlke.qtag.parser.log.model.fridgetag.ILogDataFridgeTag;
import com.zuehlke.qtag.parser.log.model.fridgetag.LogFileVersionFridgeTag;
import com.zuehlke.qtag.parser.log.model.fridgetag.LogPointFridgeTag;
import java.util.ArrayList;

public class LogDataFridgeTag
extends LogData
implements ILogDataFridgeTag {
    private DevicesFridgeTag device;
    private LogFileVersionFridgeTag logFileVersion;
    private int deviceId;
    private int sensorNumber;
    private Configuration configuration;
    private History history;
    private ArrayList<LogPointFridgeTag> logPoints;
    private ArrayList<ErrorQtagDevices> errors;

    public int getSensorNumber() {
        return this.sensorNumber;
    }

    public void setSensorNumber(int sensorNumber) {
        this.sensorNumber = sensorNumber;
    }

    @Override
    public ArrayList<ErrorQtagDevices> getErrors() {
        return this.errors;
    }

    public LogFileVersionFridgeTag getLogFileVersion() {
        return this.logFileVersion;
    }

    public ArrayList<LogPointFridgeTag> getLogPoints() {
        return this.logPoints;
    }

    public void setDevice(DevicesFridgeTag device) {
        this.device = device;
    }

    public void setDeviceId(int deviceId) {
        this.deviceId = deviceId;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setHistory(History history) {
        this.history = history;
    }

    public LogDataFridgeTag(LogData logData) {
        this.setSerialNumber(logData.getSerialNumber());
        this.setSignature(logData.getSignature());
        this.setSignature(logData.getSignature());
        this.setFwVersion(logData.getFwVersion());
        this.setQtagDevice(logData.getQtagDevice());
        this.init();
    }

    public LogDataFridgeTag() {
        this.init();
    }

    @Override
    public DevicesFridgeTag getDevice() {
        return this.device;
    }

    private void init() {
        this.configuration = new Configuration();
        this.history = new History();
        this.logPoints = new ArrayList(100);
        this.errors = new ArrayList(0);
    }

    @Override
    public int getDeviceId() {
        return this.deviceId;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public History getHistory() {
        return this.history;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        String NEW_LINE = System.getProperty("line.separator");
        sb.append("---- Log File Data ----").append(NEW_LINE);
        sb.append(" Log File version: ").append(this.logFileVersion.toString()).append(NEW_LINE);
        sb.append(" Device: ").append(this.device.toString()).append(". Device ID: ").append(this.deviceId).append(NEW_LINE);
        sb.append(" Sensor Number: ").append(this.sensorNumber).append(NEW_LINE);
        sb.append("->  Configuration: ").append("\n").append(this.configuration).append(NEW_LINE);
        sb.append("-> Result: ").append("\n").append(this.history).append(NEW_LINE);
        return sb.toString();
    }

    public void setLogFileVersion(LogFileVersionFridgeTag version) {
        this.logFileVersion = version;
    }

    @Override
    public boolean isTemperatureAlarmOccurred() {
        boolean alarmOccurred = false;
        if (this.history != null) {
            alarmOccurred = this.history.isTemperatureAlarmOccurred();
        }
        return alarmOccurred;
    }

    @Override
    public boolean isSensorAlarmOccurred() {
        boolean alarmOccurred = false;
        if (this.history != null) {
            alarmOccurred = this.history.isSensorAlarmOccurred();
        }
        return alarmOccurred;
    }
}

