/*
 * Decompiled with CFR 0.152.
 */
package com.zuehlke.qtag.parser.log.model.fridgetag;

public enum LogFileVersionFridgeTag {
    UNKNOWN,
    OLDER,
    V0_3(0.3),
    V0_4(0.4),
    V0_5(0.5),
    V1_0(1.0),
    NEWER;

    private static final double minSupportedVersion = 0.4;
    private static final double maxSupportedVersion = 1.99;
    private double version;

    private LogFileVersionFridgeTag(double version) {
        this.version = version;
    }

    private LogFileVersionFridgeTag() {
        this.version = 0.0;
    }

    public String toString() {
        return Double.toString(this.version);
    }

    public double getVersion() {
        return this.version;
    }

    public void setVersion(double version) {
        this.version = version;
    }

    public static LogFileVersionFridgeTag fromString(String version) {
        LogFileVersionFridgeTag versionFridgeTag = UNKNOWN;
        try {
            double d = Double.parseDouble(version);
            for (LogFileVersionFridgeTag v : LogFileVersionFridgeTag.values()) {
                if (v.getVersion() != d) continue;
                return v;
            }
            if (d > V1_0.getVersion()) {
                versionFridgeTag = NEWER;
                versionFridgeTag.setVersion(d);
            } else if (d < V0_3.getVersion()) {
                versionFridgeTag = OLDER;
                versionFridgeTag.setVersion(d);
            } else {
                versionFridgeTag = UNKNOWN;
            }
            return versionFridgeTag;
        }
        catch (NumberFormatException e) {
            return UNKNOWN;
        }
    }

    public boolean isSameOrNewerLogFileVersion(LogFileVersionFridgeTag logFileVersion) {
        return this.ordinal() >= logFileVersion.ordinal();
    }

    public boolean isSupported() {
        return this.version >= 0.4 && this.version <= 1.99;
    }
}

