/*
 * Decompiled with CFR 0.152.
 */
package com.zuehlke.qtag.parser.obfuscation;

import com.zuehlke.qtag.parser.obfuscation.EncryptionKeys;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class DecryptedLogFile {
    private String decryptedContent;

    public DecryptedLogFile(String initialContent, int startPos, int endPos, String decryptedDataSection) {
        this.decryptedContent = DecryptedLogFile.recompose(initialContent, startPos, endPos, decryptedDataSection);
    }

    @NotNull
    public static DecryptedLogFile createFrom(String initialContent, String decryptedDataSection) {
        int startPos = DecryptedLogFile.parseStartPos(initialContent);
        int endPos = DecryptedLogFile.parseEndPos(initialContent);
        return new DecryptedLogFile(initialContent, startPos, endPos, decryptedDataSection);
    }

    protected static int parseEndPos(String initialContent) {
        Pattern pattern = Pattern.compile((Object)((Object)EncryptionKeys.ENCRYPTED_DATA_LENGTH) + ":\\s?(.*)\r\n");
        Matcher matcher = pattern.matcher(initialContent);
        if (matcher.find()) {
            return matcher.end();
        }
        return 0;
    }

    protected static int parseStartPos(String initialContent) {
        Pattern pattern = Pattern.compile((Object)((Object)EncryptionKeys.ENCRYPTED_DATA) + ":");
        Matcher matcher = pattern.matcher(initialContent);
        if (matcher.find()) {
            return matcher.start();
        }
        return 0;
    }

    @NotNull
    protected static String recompose(@NotNull String initialContent, int startPos, int endPos, String decryptedDataSection) {
        return initialContent.substring(0, startPos) + decryptedDataSection + initialContent.substring(endPos);
    }

    public String getDecryptedContent() {
        return this.decryptedContent;
    }
}

