/*
 * Decompiled with CFR 0.152.
 */
package com.zuehlke.qtag.parser.obfuscation;

import com.zuehlke.qtag.parser.obfuscation.EncryptionKeys;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EncryptedDataSection {
    private int startPos = 0;
    private int length = 0;
    private byte[] encryptedData = null;

    public EncryptedDataSection(int startPos, int length, byte[] encryptedData) {
        this.startPos = startPos;
        this.length = length;
        this.encryptedData = encryptedData;
    }

    public static EncryptedDataSection fetchEncryptedData(String logFileAsString, byte[] logFileContent) {
        int startPos = EncryptedDataSection.getStartPos(logFileAsString);
        int length = EncryptedDataSection.getLength(logFileAsString);
        byte[] encryptedData = EncryptedDataSection.fetchEncryptedData(startPos, length, logFileContent);
        return new EncryptedDataSection(startPos, length, encryptedData);
    }

    public int getStartPos() {
        return this.startPos;
    }

    public int getLength() {
        return this.length;
    }

    public byte[] getEncryptedData() {
        return this.encryptedData;
    }

    private static byte[] fetchEncryptedData(int startPos, int length, byte[] logFileContent) {
        return Arrays.copyOfRange(logFileContent, startPos, startPos + length);
    }

    private static int getLength(String logFileAsString) {
        Pattern pattern = Pattern.compile((Object)((Object)EncryptionKeys.ENCRYPTED_DATA_LENGTH) + ":\\s?(.*)");
        Matcher matcher = pattern.matcher(logFileAsString);
        int length = 0;
        if (matcher.find()) {
            try {
                length = Integer.parseInt(matcher.group(1));
            }
            catch (NumberFormatException e) {
                length = 0;
            }
        }
        return length;
    }

    private static int getStartPos(String logFileAsString) {
        Pattern pattern = Pattern.compile((Object)((Object)EncryptionKeys.ENCRYPTED_DATA) + ":\r\n");
        Matcher matcher = pattern.matcher(logFileAsString);
        if (matcher.find()) {
            return matcher.end();
        }
        return 0;
    }
}

