/*
 * Decompiled with CFR 0.152.
 */
package com.zuehlke.qtag.parser.obfuscation;

import com.zuehlke.qtag.parser.obfuscation.EncryptionKeys;
import com.zuehlke.qtag.parser.obfuscation.LogFileDecrypter;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Key {
    private byte[] key = null;

    public Key(byte[] key) {
        this.key = key;
    }

    @NotNull
    @Contract(value="_ -> new")
    public static Key parseKey(String logFileAsString) throws IOException {
        String confSection = Key.fetchConfSection(logFileAsString);
        if (confSection == null) {
            return new Key(null);
        }
        byte[] key = LogFileDecrypter.createKey(confSection);
        return new Key(key);
    }

    @Nullable
    protected static String fetchConfSection(String input) {
        String sb = "(?<=^" + (Object)((Object)EncryptionKeys.CONFIGURATION) + ":\\r\\n)(.*?)(?=^" + (Object)((Object)EncryptionKeys.ENCRYPTED_DATA) + ":)";
        Pattern p = Pattern.compile(sb, 40);
        Matcher m = p.matcher(input);
        if (m.find()) {
            return m.group();
        }
        return null;
    }

    public byte[] getKey() {
        return this.key;
    }
}

