/*
 * Decompiled with CFR 0.152.
 */
package com.zuehlke.qtag.parser.obfuscation;

import com.zuehlke.qtag.parser.log.LogFileParser;
import com.zuehlke.qtag.parser.log.LogFileParserCLmdoc;
import com.zuehlke.qtag.parser.log.LogFilePreParser;
import com.zuehlke.qtag.parser.log.LogFileReader;
import com.zuehlke.qtag.parser.log.MissingKeyException;
import com.zuehlke.qtag.parser.log.UnsupportedLogFileException;
import com.zuehlke.qtag.parser.log.model.clmdoc.LogDataCLmdoc;
import com.zuehlke.qtag.parser.obfuscation.DecryptedLogFile;
import com.zuehlke.qtag.parser.obfuscation.EncryptedDataSection;
import com.zuehlke.qtag.parser.obfuscation.Key;
import com.zuehlke.qtag.parser.verification.Hasher;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.commons.io.FileUtils;

public class LogFileDecrypter {
    private static final String CHARSET_NAME = "ISO_8859_1";

    public static boolean isEncrypted(File inputFile) throws IOException, MissingKeyException, UnsupportedLogFileException {
        LogFileReader logFileReader = new LogFileReader(inputFile);
        LogFileParser logFileParser = LogFilePreParser.getLogFileParser(logFileReader.getLogFileRawData());
        if (logFileParser instanceof LogFileParserCLmdoc) {
            LogDataCLmdoc logDataCLmdoc = ((LogFileParserCLmdoc)logFileParser).parse();
            return logDataCLmdoc.getConfiguration().getConfigurationFlags().isAlarmDataEncrypted();
        }
        return false;
    }

    public static void decrypt(File inputFile, File outputFile) throws IOException {
        String logFileAsString = FileUtils.readFileToString(inputFile);
        byte[] logFileContent = FileUtils.readFileToByteArray(inputFile);
        Key key = Key.parseKey(logFileAsString);
        EncryptedDataSection encryptedData = EncryptedDataSection.fetchEncryptedData(logFileAsString, logFileContent);
        String decryptedData = LogFileDecrypter.decrypt(key, encryptedData);
        DecryptedLogFile decryptedLogFile = DecryptedLogFile.createFrom(logFileAsString, decryptedData);
        FileUtils.writeStringToFile(outputFile, decryptedLogFile.getDecryptedContent());
    }

    public static byte[] createKey(String seed) throws UnsupportedEncodingException {
        return Hasher.newSHA256().computeHash(seed.getBytes(CHARSET_NAME));
    }

    protected static String decrypt(Key key, EncryptedDataSection encryptedData) throws UnsupportedEncodingException {
        byte[] decrypted = LogFileDecrypter.xor(key.getKey(), encryptedData.getEncryptedData());
        return new String(decrypted, CHARSET_NAME);
    }

    private static byte[] xor(byte[] key, byte[] data) {
        byte[] result = new byte[data.length];
        int d = 0;
        int k = 0;
        while (d < data.length) {
            if (k >= key.length) {
                k = 0;
            }
            result[d] = (byte)(key[k] ^ data[d]);
            ++d;
            ++k;
        }
        return result;
    }
}

