/*
 * Decompiled with CFR 0.152.
 */
package com.zuehlke.qtag.parser.verification;

import com.zuehlke.qtag.parser.verification.CryptoHelper;
import com.zuehlke.qtag.parser.verification.HexUtils;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.provider.JCEECPublicKey;
import org.bouncycastle.jce.provider.asymmetric.ec.EC5Util;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.math.ec.ECCurve;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

class ECDSABouncycastleCryptoHelper
implements CryptoHelper {
    private static final String KEYFACT_ALGO = "ECDSA";
    private static final String NAMED_CURVE = "secp256r1";
    private static final String CRYPTO_PROVIDER = "BC";
    private KeyFactory keyFactory;
    private ECNamedCurveParameterSpec ecNamedCurve;

    ECDSABouncycastleCryptoHelper() {
    }

    private ECNamedCurveParameterSpec getNamedCurve() {
        if (this.ecNamedCurve == null) {
            this.ecNamedCurve = ECNamedCurveTable.getParameterSpec(NAMED_CURVE);
        }
        return this.ecNamedCurve;
    }

    private KeyFactory getKeyFactory() throws GeneralSecurityException {
        if (this.keyFactory == null) {
            this.keyFactory = KeyFactory.getInstance(KEYFACT_ALGO, CRYPTO_PROVIDER);
        }
        return this.keyFactory;
    }

    @Override
    public Provider getProvider() {
        return new BouncyCastleProvider();
    }

    @Override
    public byte[] decodeSignature(String encodedSig) {
        if (encodedSig == null || encodedSig.length() != 128) {
            throw new RuntimeException("invalid EC signature: " + encodedSig);
        }
        return this.decodeSignature(encodedSig.substring(0, 64), encodedSig.substring(64));
    }

    public PrivateKey decodePrivateKey(String encodedPrivKeyS) {
        if (encodedPrivKeyS == null || encodedPrivKeyS.length() != 64) {
            throw new RuntimeException("invalid EC private key (s-component): " + encodedPrivKeyS);
        }
        try {
            ECNamedCurveParameterSpec ecNamedCurve = this.getNamedCurve();
            EllipticCurve ellipticCurve = EC5Util.convertCurve(ecNamedCurve.getCurve(), ecNamedCurve.getSeed());
            ECParameterSpec ecParameter = EC5Util.convertSpec(ellipticCurve, ecNamedCurve);
            BigInteger s = ECDSABouncycastleCryptoHelper.decodeBigInt(encodedPrivKeyS);
            ECPrivateKeySpec keySpec = new ECPrivateKeySpec(s, ecParameter);
            return this.getKeyFactory().generatePrivate(keySpec);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PublicKey decodePublicKey(String encodedPubKey) {
        if (encodedPubKey == null || encodedPubKey.length() != 128) {
            throw new RuntimeException("invalid EC public key: " + encodedPubKey);
        }
        return this.decodePublicKey(encodedPubKey.substring(0, 64), encodedPubKey.substring(64));
    }

    PublicKey decodePublicKey(String encodedPubKeyX, String encodedPubKeyY) {
        if (encodedPubKeyX == null || encodedPubKeyX.length() != 64) {
            throw new RuntimeException("invalid EC public key (x-component): " + encodedPubKeyX);
        }
        if (encodedPubKeyY == null || encodedPubKeyY.length() != 64) {
            throw new RuntimeException("invalid EC public key (y-component): " + encodedPubKeyY);
        }
        try {
            String inversedPubKeyX = HexUtils.inverseHex(encodedPubKeyX);
            String inversedPubKeyY = HexUtils.inverseHex(encodedPubKeyY);
            BigInteger x = new BigInteger(inversedPubKeyX, 16);
            BigInteger y = new BigInteger(inversedPubKeyY, 16);
            ECNamedCurveParameterSpec ecNamedCurve = ECNamedCurveTable.getParameterSpec(NAMED_CURVE);
            EllipticCurve ellipticCurve = EC5Util.convertCurve(ecNamedCurve.getCurve(), ecNamedCurve.getSeed());
            ECParameterSpec ecParameter = EC5Util.convertSpec(ellipticCurve, ecNamedCurve);
            ECPublicKeySpec keySpec = new ECPublicKeySpec(new ECPoint(x, y), ecParameter);
            KeyFactory keyFactory = KeyFactory.getInstance(KEYFACT_ALGO, CRYPTO_PROVIDER);
            return keyFactory.generatePublic(keySpec);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    byte[] decodeSignature(String encodedSigR, String encodedSigS) {
        if (encodedSigR == null || encodedSigR.length() != 64) {
            throw new RuntimeException("invalid signature (r-component): " + encodedSigR);
        }
        if (encodedSigS == null || encodedSigS.length() != 64) {
            throw new RuntimeException("invalid signature (s-component): " + encodedSigS);
        }
        BigInteger r = ECDSABouncycastleCryptoHelper.decodeBigInt(encodedSigR);
        BigInteger s = ECDSABouncycastleCryptoHelper.decodeBigInt(encodedSigS);
        ASN1Integer asn1IntR = new ASN1Integer(r);
        ASN1Integer asn1IntS = new ASN1Integer(s);
        DERSequence seq = new DERSequence(new ASN1Integer[]{asn1IntR, asn1IntS});
        try {
            return seq.getEncoded("BER");
        }
        catch (IOException e) {
            return seq.getDEREncoded();
        }
    }

    @NotNull
    @Contract(value="_ -> new")
    private static BigInteger decodeBigInt(String hexEncoded) {
        StringBuilder sb = new StringBuilder();
        for (int i = hexEncoded.length(); i > 0; i -= 2) {
            sb.append(hexEncoded.substring(i - 2, i));
        }
        String hexEncodedReversed = sb.toString();
        return new BigInteger(hexEncodedReversed, 16);
    }

    @Override
    public boolean verifySignature(byte[] hash, PublicKey pubKey, byte[] signature) {
        try {
            if (pubKey instanceof JCEECPublicKey) {
                return this.verifySignature(hash, (JCEECPublicKey)pubKey, signature);
            }
            throw new RuntimeException("Unsupported PublicKey. Only JCEECPublicKeys supported.");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    boolean verifySignature(byte[] hash, @NotNull JCEECPublicKey pubKey, byte[] sig) {
        org.bouncycastle.math.ec.ECPoint q = pubKey.getQ();
        return this.verifySignature(hash, q.getX().toBigInteger(), q.getY().toBigInteger(), sig);
    }

    boolean verifySignature(byte[] hash, BigInteger x, BigInteger y, byte[] sig) {
        ECNamedCurveParameterSpec ecSpec = ECNamedCurveTable.getParameterSpec(NAMED_CURVE);
        ECCurve curve = ecSpec.getCurve();
        org.bouncycastle.math.ec.ECPoint g = ecSpec.getG();
        BigInteger n = ecSpec.getN();
        BigInteger h = ecSpec.getH();
        ECDomainParameters domainParams = new ECDomainParameters(curve, g, n, h, ecSpec.getSeed());
        org.bouncycastle.math.ec.ECPoint q = ecSpec.getCurve().createPoint(x, y, false);
        ECPublicKeyParameters publicKey = new ECPublicKeyParameters(q, domainParams);
        BigInteger[] sigRS = this.encodeSignatureToBigIntegers(sig);
        BigInteger signature_r = sigRS[0];
        BigInteger signature_s = sigRS[1];
        String inversedHash = HexUtils.inverseHex(HexUtils.toHex(hash));
        ECDSASigner signer = new ECDSASigner();
        signer.init(false, publicKey);
        try {
            return signer.verifySignature(HexUtils.fromHex(inversedHash), signature_r, signature_s);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    @Contract(value="_ -> new")
    private BigInteger[] encodeSignatureToBigIntegers(byte[] signature) {
        ASN1Sequence seq;
        try {
            seq = (ASN1Sequence)new ASN1InputStream(signature).readObject();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ASN1Integer asn1IntR = (ASN1Integer)seq.getObjectAt(0);
        ASN1Integer asn1IntS = (ASN1Integer)seq.getObjectAt(1);
        return new BigInteger[]{asn1IntR.getValue(), asn1IntS.getValue()};
    }
}

