/*
 * Decompiled with CFR 0.152.
 */
package com.zuehlke.qtag.parser.verification;

import com.zuehlke.qtag.parser.log.model.Signature;
import com.zuehlke.qtag.parser.verification.SHA256WithECDSASignatureVerifier;
import com.zuehlke.qtag.parser.verification.SignatureParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class FileSignatureVerifier {
    public static final String SUPPORTED_CERTIFICATE_VERSION = "1.0";
    private static final String MASTER_PUB_KEY_RESSOURCE = "/master_pub.qkey";
    private static final String CHARSET_NAME = "ISO_8859_1";
    private SHA256WithECDSASignatureVerifier verifier = new SHA256WithECDSASignatureVerifier();
    private String qtagMasterPubKey;

    private FileSignatureVerifier(String qtagMasterPubKey) {
        this.qtagMasterPubKey = qtagMasterPubKey;
    }

    public static FileSignatureVerifier create() {
        InputStream is = null;
        try {
            is = FileSignatureVerifier.class.getResourceAsStream(MASTER_PUB_KEY_RESSOURCE);
            FileSignatureVerifier fileSignatureVerifier = new FileSignatureVerifier(IOUtils.toString(is));
            return fileSignatureVerifier;
        }
        catch (IOException e) {
            throw new RuntimeException("unable to read master public key from /master_pub.qkey", e);
        }
        finally {
            IOUtils.closeQuietly(is);
        }
    }

    public boolean isPdfSignatureValid(File pdfFile) throws IOException {
        String pdfFileContent = FileUtils.readFileToString(pdfFile, CHARSET_NAME);
        Pattern pattern = Pattern.compile("Cert:.*(?=endstream)", 32);
        Matcher matcher = pattern.matcher(pdfFileContent);
        if (!matcher.find()) {
            throw new IOException("Could not find the signature.");
        }
        String certificateWithSignature = matcher.group(0);
        String[] tokens = pattern.split(pdfFileContent);
        if (tokens.length > 2) {
            throw new IOException("Found more than one signature.");
        }
        String content = tokens[0] + tokens[1];
        return this.isSignatureValid(certificateWithSignature, content);
    }

    public boolean isLogSignatureValid(File inputFile) throws IOException {
        String logFileContent = FileUtils.readFileToString(inputFile, CHARSET_NAME);
        Pattern signatureBlockPattern = Pattern.compile("Cert:.*", 32);
        Matcher matcher = signatureBlockPattern.matcher(logFileContent);
        if (!matcher.find()) {
            throw new IOException("Could not find a certificate block.");
        }
        String certificateWithSignature = matcher.group(0);
        Pattern contentSignaturePattern = Pattern.compile("Sig: .*", 32);
        String[] tokens = contentSignaturePattern.split(logFileContent);
        if (!contentSignaturePattern.matcher(logFileContent).find()) {
            throw new IOException("Could not find the signature.");
        }
        if (tokens.length > 1) {
            throw new IOException("Found more than signature.");
        }
        String content = tokens[0];
        return this.isSignatureValid(certificateWithSignature, content);
    }

    private boolean isSignatureValid(String certificateWithSignature, String content) throws IOException {
        Signature signature = SignatureParser.parseFrom(certificateWithSignature);
        if (!SUPPORTED_CERTIFICATE_VERSION.equals(signature.getCertificate().getVersion())) {
            throw new IOException("Unsupported certificate version: " + signature.getCertificate().getVersion() + " (expected: " + SUPPORTED_CERTIFICATE_VERSION + ")");
        }
        boolean isContentSignatureValid = this.verifier.verifySignature(content.getBytes(CHARSET_NAME), signature.getCertificate().getPublicKey(), signature.getContentSignature());
        String signatureCertificateStartString = SignatureParser.Key.SIGNATURE_CERTIFICATE.getKeyName();
        int signatureCertificateStartIndex = certificateWithSignature.indexOf(signatureCertificateStartString);
        String cert = certificateWithSignature.substring(0, signatureCertificateStartIndex);
        boolean isCertificateValid = this.verifier.verifySignature(cert.getBytes(CHARSET_NAME), this.qtagMasterPubKey, signature.getCertSignature());
        return isCertificateValid && isContentSignatureValid;
    }
}

