/*
 * Decompiled with CFR 0.152.
 */
package com.zuehlke.qtag.parser.verification;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class Hasher {
    private static final String SHA256_ALGO = "SHA-256";
    private String algorithm;

    private Hasher(String theAlgorithm) {
        this.algorithm = theAlgorithm;
    }

    public static Hasher newSHA256() {
        return new Hasher(SHA256_ALGO);
    }

    public byte[] computeHash(byte[] data) {
        try {
            MessageDigest md = MessageDigest.getInstance(this.algorithm);
            md.update(data);
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("unable to compute hash due to missing algorithm " + this.algorithm, e);
        }
    }
}

