/*
 * Decompiled with CFR 0.152.
 */
package com.zuehlke.qtag.parser.verification;

import com.zuehlke.qtag.parser.verification.CryptoHelper;
import com.zuehlke.qtag.parser.verification.ECDSABouncycastleCryptoHelper;
import com.zuehlke.qtag.parser.verification.Hasher;
import java.security.PublicKey;
import java.security.Security;

class SHA256WithECDSASignatureVerifier {
    private CryptoHelper crypteHelper;
    private Hasher hasher;

    public SHA256WithECDSASignatureVerifier() {
        this(Hasher.newSHA256(), new ECDSABouncycastleCryptoHelper());
    }

    SHA256WithECDSASignatureVerifier(Hasher hasher, CryptoHelper cryptoHelper) {
        this.hasher = hasher;
        this.crypteHelper = cryptoHelper;
        Security.addProvider(this.crypteHelper.getProvider());
    }

    public boolean verifySignature(byte[] data, String pubKey, String signature) {
        byte[] hash = this.hasher.computeHash(data);
        PublicKey publicKey = this.crypteHelper.decodePublicKey(pubKey);
        byte[] sig = this.crypteHelper.decodeSignature(signature);
        return this.crypteHelper.verifySignature(hash, publicKey, sig);
    }
}

