/*
 * Decompiled with CFR 0.152.
 */
package com.zuehlke.qtag.parser.verification;

import com.zuehlke.qtag.parser.log.model.Certificate;
import com.zuehlke.qtag.parser.log.model.Signature;
import java.util.Scanner;

class SignatureParser {
    SignatureParser() {
    }

    public static Signature parseFrom(String string) {
        Scanner scanner = new Scanner(string);
        Certificate certificate = new Certificate();
        Signature result = new Signature();
        result.setCertificate(certificate);
        block10: while (scanner.hasNextLine()) {
            String trimmedLine = scanner.nextLine().trim();
            if ("Cert:".equals(trimmedLine)) continue;
            String[] keyValue = trimmedLine.split(": ");
            String value = keyValue[1];
            Key key = Key.fromName(keyValue[0]);
            switch (key) {
                case VERSION: {
                    certificate.setVersion(value);
                    continue block10;
                }
                case LOT: {
                    certificate.setLot(value);
                    continue block10;
                }
                case ISSUER: {
                    certificate.setIssuer(value);
                    continue block10;
                }
                case VALID_FROM: {
                    certificate.setValidFromTimestamp(value);
                    continue block10;
                }
                case OWNER: {
                    certificate.setOwner(value);
                    continue block10;
                }
                case PUBLIC_KEY: {
                    certificate.setPublicKey(value);
                    continue block10;
                }
                case SIGNATURE_CERTIFICATE: {
                    result.setCertSignature(value);
                    continue block10;
                }
                case SIGNATURE_LOT: {
                    result.setContentSignature(value);
                    continue block10;
                }
            }
            throw new RuntimeException("unexpected key found: " + (Object)((Object)key));
        }
        return result;
    }

    static enum Key {
        SIGNATURE_CERTIFICATE("Sig Cert"),
        SIGNATURE_LOT("Sig"),
        VERSION("Vers"),
        LOT("Lot"),
        ISSUER("Issuer"),
        VALID_FROM("Valid from"),
        OWNER("Owner"),
        PUBLIC_KEY("Public Key");

        private String keyName;

        private Key(String keyName) {
            this.keyName = keyName;
        }

        public String getKeyName() {
            return this.keyName;
        }

        public static Key fromName(String keyName) {
            if (keyName == null || keyName.trim().isEmpty()) {
                throw new IllegalArgumentException("keyName can not be null or empty");
            }
            String keyNameTrimmed = keyName.trim();
            for (Key key : Key.values()) {
                if (!keyNameTrimmed.equals(key.keyName)) continue;
                return key;
            }
            throw new IllegalArgumentException("Unexpected keyName: " + keyName);
        }
    }
}

