/*
 * Decompiled with CFR 0.152.
 */
package com.zuehlke.qtag.util;

import java.text.DecimalFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class CalendarUtils {
    private static final DecimalFormat XX_FORMAT = new DecimalFormat("00");
    private static final DecimalFormat XXX_FORMAT = new DecimalFormat("000");
    private static final DecimalFormat XXXX_FORMAT = new DecimalFormat("0000");
    private static final String LOGFILE_DATE_FORMAT_PATTERN_TIMESTAMP = "yyyy-MM-dd H:mm";
    private static final String LOGFILE_DATE_FORMAT_PATTERN_DATE = "yyyy-MM-dd";
    private static final String LOGFILE_DATE_FORMAT_PATTERN_TIME = "H:mm";

    private CalendarUtils() {
    }

    public static Calendar parseAsCalendar(String text, TimeZone timeZone) {
        return CalendarUtils.parseAsCalendar(text, timeZone, LOGFILE_DATE_FORMAT_PATTERN_TIMESTAMP);
    }

    public static Calendar parseAsCalendarFromDate(String text, TimeZone timeZone) {
        return CalendarUtils.parseAsCalendar(text, timeZone, LOGFILE_DATE_FORMAT_PATTERN_DATE);
    }

    public static Calendar parseAsCalendarFromTime(String text, TimeZone timeZone, LocalDate date) {
        return CalendarUtils.parseAsCalendar(text, timeZone, LOGFILE_DATE_FORMAT_PATTERN_TIME);
    }

    public static LocalTime parseAsLocalTime(String text) {
        return CalendarUtils.parseAsLocalTime(text, LOGFILE_DATE_FORMAT_PATTERN_TIME);
    }

    public static LocalDate parseAsLocalDate(String text) {
        return CalendarUtils.parseAsLocalDate(text, LOGFILE_DATE_FORMAT_PATTERN_DATE);
    }

    @NotNull
    @Contract(value="null -> fail")
    public static LocalDateTime parseAsLocalDateTime(String text) {
        return CalendarUtils.parseAsLocalDateTime(text, LOGFILE_DATE_FORMAT_PATTERN_TIMESTAMP);
    }

    @NotNull
    @Contract(value="null -> fail")
    public static String formatDate(Calendar cal) {
        if (cal == null) {
            throw new IllegalArgumentException("Calender can not be null");
        }
        String buf = XX_FORMAT.format(cal.get(5)) + "." + XX_FORMAT.format(cal.get(2) + 1) + "." + XXXX_FORMAT.format(cal.get(1));
        return buf;
    }

    @NotNull
    @Contract(value="null -> fail")
    public static String formatTime(Calendar cal) {
        if (cal == null) {
            throw new IllegalArgumentException("Calender can not be null");
        }
        return XX_FORMAT.format(cal.get(11)) + ":" + XX_FORMAT.format(cal.get(12));
    }

    @NotNull
    @Contract(value="null -> fail")
    public static String formatTimestamp(Calendar cal) {
        if (cal == null) {
            throw new IllegalArgumentException("Calender can not be null");
        }
        return XXXX_FORMAT.format(cal.get(1)) + XX_FORMAT.format(cal.get(2) + 1) + XX_FORMAT.format(cal.get(5)) + XX_FORMAT.format(cal.get(11)) + XX_FORMAT.format(cal.get(12)) + XX_FORMAT.format(cal.get(13));
    }

    @NotNull
    public static String formatDuration(int min) {
        if (min == 0) {
            return "";
        }
        long remainder = min;
        long days = remainder / 1440L;
        long hours = (remainder %= 1440L) / 60L;
        long minutes = remainder %= 60L;
        StringBuilder buf = new StringBuilder();
        if (days > 0L) {
            buf.append(days).append("d ");
        }
        if (hours > 0L) {
            buf.append(hours).append("h ");
        }
        if (minutes > 0L) {
            buf.append(minutes).append("min ");
        }
        return buf.toString().trim();
    }

    @NotNull
    public static String formatISO(Calendar cal) {
        if (cal == null) {
            return "";
        }
        int year = cal.get(1);
        if (cal.isSet(0) && cal.get(0) == 0) {
            year = -year + 1;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(XXXX_FORMAT.format(year));
        buf.append('-');
        buf.append(XX_FORMAT.format(cal.get(2) + 1));
        buf.append('-');
        buf.append(XX_FORMAT.format(cal.get(5)));
        buf.append('T');
        buf.append(XX_FORMAT.format(cal.get(11)));
        buf.append(':');
        buf.append(XX_FORMAT.format(cal.get(12)));
        buf.append(':');
        buf.append(XX_FORMAT.format(cal.get(13)));
        buf.append('.');
        buf.append(XXX_FORMAT.format(cal.get(14)));
        TimeZone tz = cal.getTimeZone();
        int offset = tz.getOffset(cal.getTimeInMillis());
        if (offset != 0) {
            int hours = Math.abs(offset / 60000 / 60);
            int minutes = Math.abs(offset / 60000 % 60);
            buf.append(offset < 0 ? (char)'-' : '+');
            buf.append(XX_FORMAT.format(hours));
            buf.append(':');
            buf.append(XX_FORMAT.format(minutes));
        } else {
            buf.append('Z');
        }
        return buf.toString();
    }

    private static Calendar parseAsCalendar(String text, TimeZone timeZone, String pattern) {
        if (text == null) {
            throw new IllegalArgumentException("String text can not be null");
        }
        if (timeZone == null) {
            throw new IllegalArgumentException("timeZone can not be null");
        }
        DateTimeZone dateTimeZone = DateTimeZone.forTimeZone(timeZone);
        DateTimeFormatter formatter = DateTimeFormat.forPattern(pattern).withOffsetParsed().withZone(dateTimeZone);
        DateTime dateTime = formatter.parseDateTime(text);
        GregorianCalendar cal = dateTime.toGregorianCalendar();
        if (dateTimeZone.getID().equals("UTC")) {
            cal.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        return cal;
    }

    private static LocalTime parseAsLocalTime(String text, String pattern) {
        if (text == null) {
            throw new IllegalArgumentException("String text can not be null");
        }
        java.time.format.DateTimeFormatter formatter = java.time.format.DateTimeFormatter.ofPattern(pattern);
        return LocalTime.parse(text, formatter);
    }

    private static LocalDate parseAsLocalDate(String text, String pattern) {
        if (text == null) {
            throw new IllegalArgumentException("String text can not be null");
        }
        java.time.format.DateTimeFormatter formatter = java.time.format.DateTimeFormatter.ofPattern(pattern);
        return LocalDate.parse(text, formatter);
    }

    @NotNull
    @Contract(value="null, _ -> fail")
    private static LocalDateTime parseAsLocalDateTime(String text, String pattern) {
        if (text == null) {
            throw new IllegalArgumentException("String text can not be null");
        }
        java.time.format.DateTimeFormatter formatter = java.time.format.DateTimeFormatter.ofPattern(pattern);
        return LocalDateTime.parse(text, formatter);
    }
}

